<?php
namespace Visiosoft\CicekciDemodataExtension;

use \Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Application\Application;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Symfony\Component\Console\Input\ArgvInput;


class CicekciDemodataExtensionSeeder extends Seeder
{
    public function run()
    {
        $application_reference = (new ArgvInput())->getParameterOption('--app', env('APPLICATION_REFERENCE', 'default'));

        // SQL file seeding
        Model::unguard();
        DB::unprepared(str_replace('{application_reference}', $application_reference, file_get_contents(realpath(dirname(__DIR__)) . '/src/Seed/Data/cicekci.sql')));
        Model::reguard();
        $zip = new \ZipArchive();
        $zip->open(__DIR__ . '/Seed/Data/cicekci.zip', \ZipArchive::CREATE);
        $zip->extractTo(storage_path('streams/'.app(Application::class)->getReference().'/files-module/'));
        $zip->close();

        $this->command->call('files:sync');
        Artisan::call('assets:clear');
    }
}