<?php
namespace Visiosoft\CicekciDemodataExtension;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use \Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Application\Application;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Symfony\Component\Console\Input\ArgvInput;


class CicekciDemodataExtensionSeeder extends Seeder
{
    private $settingRepository;

    public function __construct(
        SettingRepositoryInterface $settingRepository
    )
    {
        parent::__construct();
        $this->settingRepository = $settingRepository;
    }
    public function run()
    {
        $application_reference = (new ArgvInput())->getParameterOption('--app', env('APPLICATION_REFERENCE', 'default'));

        $this->settingRepository->set('visiosoft.theme.dress::horizontal_menu_categories', 'a:8:{i:0;s:1:"1";i:1;s:1:"2";i:2;s:1:"3";i:3;s:1:"4";i:4;s:1:"5";i:5;s:1:"6";i:6;s:1:"8";i:7;s:2:"26";}');
        // SQL file seeding
        Model::unguard();
        DB::unprepared(str_replace('{application_reference}', $application_reference, file_get_contents(realpath(dirname(__DIR__)) . '/src/Seed/Data/cicekci.sql')));
        Model::reguard();
        $zip = new \ZipArchive();
        $zip->open(__DIR__ . '/Seed/Data/cicekci.zip', \ZipArchive::CREATE);
        $zip->extractTo(storage_path('streams/'.app(Application::class)->getReference().'/files-module/'));
        $zip->close();

        $this->command->call('files:sync');
        Artisan::call('assets:clear');
    }
}