<?php
namespace Visiosoft\CicekciDemodataExtension;

use \Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Application\Application;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;


class CicekciDemodataExtensionSeeder extends Seeder
{
    public function run()
    {
        // SQL file seeding
        Model::unguard();
        DB::unprepared(file_get_contents(__DIR__ . '/seed/data/cicekci.sql'));
        Model::reguard();
        $zip = new \ZipArchive();
        $zip->open(__DIR__ . '/seed/data/cicekci.zip', \ZipArchive::CREATE);
        $zip->extractTo(storage_path('streams/'.app(Application::class)->getReference().'/files-module/'));
        $zip->close();

        $this->command->call('files:sync');
        Artisan::call('assets:clear');
    }
}