<?php

namespace Visiosoft\CatsTransferExtension\Http\Controller\Admin;

use ACFBentveld\XML\XML;
use Anomaly\FilesModule\Disk\Contract\DiskRepositoryInterface;
use Anomaly\FilesModule\File\Contract\FileRepositoryInterface;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Anomaly\PostsModule\Category\CategoryModel;
use Anomaly\PostsModule\Category\Contract\CategoryRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Anomaly\Streams\Platform\Support\Str;
use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Maatwebsite\Excel\Facades\Excel;
use Visiosoft\CatsTransferExtension\Category\CategoryExport;
use Visiosoft\CatsTransferExtension\Category\CategoryImport;

class CategoryController extends AdminController
{
    public function Folder_control()
    {
        $folders = app(FolderRepositoryInterface::class);
        $disks = app(DiskRepositoryInterface::class);
        if (!$folders->findBySlug('CatsFolder')) {
            $disk = $disks->findBySlug('local');
            $folders->create(
                [
                    'en' => [
                        'name' => trans('visiosoft.extension.cats_transfer::addon.folder_name'),
                        'description' => trans('visiosoft.extension.cats_transfer::addon.folder_description'),
                    ],
                    'slug' => 'CatsFolder',
                    'disk' => $disk

                ]
            );
        }
    }


    public function exportcsv()
    {
        $Excell = new CategoryExport();
        return $Excell->download();
    }

    public function example_exportcsv()
    {
        $Excell = new CategoryExport();
        $Excell->SetExample(True);
        return $Excell->download();
    }

    public function exportxml()
    {
        $category = new CategoryModel();
        $arr = array();
        $i = 1;
        foreach ($category->all() as $item) {
            $arr['item_' . $i] = array(
                'name' => $item->getName(),
                'description' => $item->getDescription()
            );
            $i += 1;
        }
        $xml = XML::export($arr)->toString('file');
        return $this->response->make($xml, 200, [
            'Content-Description' => 'File Transfer',
            'Content-Type' => 'application/xml',
            'Content-Transfer-Encoding' => 'binary',
            "Content-disposition" => "attachment; filename=\"Categories.xml\""
        ]);
    }

    public function example_exportxml()
    {
        $arr = array(
            'item_1' => array(
                'name' => 'Example Name',
                'description' => 'Example Description'
            )
        );

        $xml = XML::export($arr)->toString('file');
        return $this->response->make($xml, 200, [
            'Content-Description' => 'File Transfer',
            'Content-Type' => 'application/xml',
            'Content-Transfer-Encoding' => 'binary',
            "Content-disposition" => "attachment; filename=\"Categories.xml\""
        ]);
    }

    public function import(FormBuilder $builder, FileRepositoryInterface $fileRepository)
    {
        $this->Folder_control();
        if (request()->action == "save" and $file = $fileRepository->find(request()->file)) {
            $pathToFolder = "/storage/streams/default/files-module/local/CatsFolder/";
            if ($file->extension === 'csv') {
                Excel::import(new CategoryImport(), base_path() . $pathToFolder . $file->name);
                $this->messages->success(trans('visiosoft.extension.cats_transfer::message.import_success'));
            } else if ($file->extension === 'xml') {
                $categories = json_decode(XML::import(base_path() . $pathToFolder . $file->name)->toJson(), true);
                $PostCategory = app(CategoryRepositoryInterface::class);
                foreach ($categories as $category) {
                    if ($category != Null) {
                        $name = (gettype($category['name']) != 'string') ? '' : $category['name'];
                        $description = (gettype($category['description']) != 'string') ? '' : $category['description'];
                        $slug = Str::slug($name);
                        $i = 1;
                        while ($PostCategory->findBySlug($slug)) {
                            $i += 1;
                            $slug = Str::slug($name . '-' . strval($i));
                        }
                        $PostCategory->create(array(
                            "slug" => $slug,
                            "name" => $name,
                            "description" => $description,
                            "meta_title" => null,
                            "meta_description" => null
                        ));
                    }
                }
                $this->messages->success(trans('visiosoft.extension.cats_transfer::message.import_success'));

            } else {
                $this->messages->error(trans('visiosoft.extension.cats_transfer::message.import_error'));
            }

        }

        return $builder->setButtons([
            'examplecsv' => [
                'href' => route('visiosoft.extension.cats_transfer::category.example_exportcsv'),
                'text' => 'visiosoft.extension.cats_transfer::button.examplecsv',
                'type' => 'info',
            ],

            'examplexml' => [
                'href' => route('visiosoft.extension.cats_transfer::category.example_exportxml'),
                'text' => 'visiosoft.extension.cats_transfer::button.examplexml',
                'type' => 'info',
            ]

        ])->setFields([
            'file' => [
                "type" => "anomaly.field_type.file",
                "config" => [
                    'folders' => ['CatsFolder'],
                    'mode' => 'upload',
                ]
            ],
        ])
            ->setActions([
                'save'
            ])
            ->setOptions([
                'redirect' => route('visiosoft.extension.cats_transfer::category.import')
            ])
            ->render();
    }
}

