<?php namespace Visiosoft\CatsTransferExtension;

use Anomaly\Streams\Platform\Addon\AddonCollection;
use Anomaly\Streams\Platform\Addon\AddonServiceProvider;

class CatsTransferExtensionServiceProvider extends AddonServiceProvider
{

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/posts/category/import' => [
            'as' => 'visiosoft.extension.cats_transfer::category.import',
            'uses' => 'Visiosoft\CatsTransferExtension\Http\Controller\Admin\CategoryController@import',
            'streams::addon' => 'anomaly.module.posts'
        ],

        'admin/posts/category/exportcsv' => [
            'as' => 'visiosoft.extension.cats_transfer::category.exportcsv',
            'uses' => 'Visiosoft\CatsTransferExtension\Http\Controller\Admin\CategoryController@exportcsv',
        ],
        'admin/posts/category/exportxml' => [
            'as' => 'visiosoft.extension.cats_transfer::category.exportxml',
            'uses' => 'Visiosoft\CatsTransferExtension\Http\Controller\Admin\CategoryController@exportxml',
        ],
        'admin/posts/category/example_exportcsv' => [
            'as' => 'visiosoft.extension.cats_transfer::category.example_exportcsv',
            'uses' => 'Visiosoft\CatsTransferExtension\Http\Controller\Admin\CategoryController@example_exportcsv',
        ],
        'admin/posts/category/example_exportxml' => [
            'as' => 'visiosoft.extension.cats_transfer::category.example_exportxml',
            'uses' => 'Visiosoft\CatsTransferExtension\Http\Controller\Admin\CategoryController@example_exportxml',
        ],
    ];

    /**
     * Boot the addon.
     */
    public function boot(AddonCollection $addonCollection)
    {

        $settings_url = [
            'exportcsv' => [
                'title' => 'visiosoft.extension.cats_transfer::button.exportcsv',
                'href' => route('visiosoft.extension.cats_transfer::category.exportcsv'),
                'page' => 'anomaly.module.posts'
            ],
            'exportxml' => [
                'title' => 'visiosoft.extension.cats_transfer::button.exportxml',
                'href' => route('visiosoft.extension.cats_transfer::category.exportxml'),
                'page' => 'anomaly.module.posts'
            ],
            'import' => [
                'title' => 'visiosoft.extension.cats_transfer::button.import',
                'href' => route('visiosoft.extension.cats_transfer::category.import'),
                'page' => 'anomaly.module.posts'
            ]
        ];

        foreach ($settings_url as $key => $value) {

            $addonCollection->get($value['page'])->addSection($key, $value);
        }


    }
}
