<?php


namespace Visiosoft\CatsTransferExtension\Category;


use Anomaly\PostsModule\Category\CategoryModel;
use Anomaly\PostsModule\Category\Contract\CategoryRepositoryInterface;
use Anomaly\Streams\Platform\Support\Str;
use Maatwebsite\Excel\Concerns\ToModel;

class CategoryImport implements ToModel
{
    /**
     * @param array $row
     *
     * @return CategoryModel|null
     */
    public function model(array $row)
    {
        $name = (empty($row[0])) ? '' : $row[0];
        $description = (empty($row[1])) ? '' : $row[1];
        $slug = Str::slug($name);
        $PostCategory = app(CategoryRepositoryInterface::class);
        $i = 1;
        while ($PostCategory->findBySlug($slug)) {
            $i += 1;
            $slug = Str::slug($name . '-' . strval($i));
        }
        return new CategoryModel([
            'name' => $name,
            'slug' => $slug,
            'description' => $description
        ]);
    }

}
