<?php


namespace Visiosoft\CatsTransferExtension\Category;


use Anomaly\PostsModule\Category\CategoryModel;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Excel;

class CategoryExport implements FromCollection
{

    use Exportable;

    private $examplecsv = False;
    private $fileName = 'Category.csv';

    /**
     * Optional Writer Type
     */
    private $writerType = Excel::CSV;

    /**
     * Optional headers
     */
    private $headers = [
        'Content-Type' => 'text/csv',
    ];

    public function collection()
    {
        if ($this->examplecsv) {
            $arr = array(array('Example Name', 'Example Description'));
        } else {
            $PostCategory = new CategoryModel();
            $arr = array();
            foreach ($PostCategory->all() as $item) {
                $arr[] = array(
                    $item->getName(),
                    $item->getDescription()
                );
            }

        }
        return collect($arr);
    }

    public function SetExample($status)
    {
        $this->examplecsv = $status;
    }
}
