function getInput(field) {
    var row = field.parent().parent();
    return $(row).find('input[name="quantity"]');
}

//plus
$('.quantity-plus-btn').on('click', function () {
    var input = getInput($(this));
    updatePrice(input, 'plus')
})

//minus
$('.quantity-minus-btn').on('click', function () {
    var input = getInput($(this));
    updatePrice(input, 'minus')
})

//change
$('input[name="quantity"]').on('change', function () {
    updatePrice(this, 'change')
})

function updatePrice(input, type) {
    var ad_id = $(input).attr('data-id');
    var current_quantity = $(input).val();

    productDetail(ad_id, current_quantity, type, function (data) {
        ChangeFieldForResponse(type, data.newPrice, data.newQuantity, data.maxQuantity)
    });

}

function productDetail(id, quantity, type, returnData) {
    if (quantity == 0) {
        quantity = 1;
    }
    $.ajax({
        type: 'POST',
        url: '/ajax/StockControl',
        data: 'id=' + id + '&quantity=' + quantity + '&type=' + type,
        success: function (data) {
            returnData(data);
        }
    });
}

function ChangeFieldForResponse(type, price, quantity, maxQuantity) {
    if (parseInt(quantity) == 1) {
        $('.quantity-minus-btn').attr('disabled', true);
    } else {
        $('.quantity-minus-btn').attr('disabled', false);
    }
    if (quantity == maxQuantity) {
        $('.quantity-plus-btn').attr('disabled', true);
    } else {
        $('.quantity-plus-btn').attr('disabled', false);
    }
    $('input[name="quantity"]').val(parseInt(quantity));
    $('.ad-price').html(price.toLocaleString())
}

$('.add-cart-button').on('click', function () {
    var quantity = $('input[name="quantity"]').val();
    var id = $('input[name="quantity"]').attr('data-id');
    return addCart(id, quantity)
})

function addCart(id, quantity) {
    $.ajax({
        type: 'POST',
        url: '/ajax/addCart',
        data: 'id=' + id + '&quantity=' + quantity,
        success: function (data) {
            if (data.status == "success") {
                window.location.href = "/cart";
            } else {
                alert(data.msg);
            }
        }
    });
}