<?php namespace Visiosoft\CartsModule\Saleitem\Command;

use Visiosoft\CartsModule\Cart\Contract\CartInterface;
use Visiosoft\CartsModule\Saleitem\Contract\SaleitemInterface;
use Visiosoft\CartsModule\Saleitem\Contract\SaleitemRepositoryInterface;
use Visiosoft\CartsModule\Saleitem\SaleitemModel;
use Anomaly\Streams\Platform\Model\EloquentModel;
use Illuminate\Foundation\Bus\DispatchesJobs;

/**
 * Class AddItem
 *
 * @link   http://openclassify.com/
 * @author OpenClassify, Inc. <support@openclassify.com>
 * @author Visiosoft Inc <support@openclassify.com>
 */
class AddSaleitem
{

    use DispatchesJobs;

    /**
     * The cart instance.
     *
     * @var CartInterface
     */
    protected $cart;

    /**
     * The item payload.
     *
     * @var mixed
     */
    protected $item;

    /**
     * The item quantity.
     *
     * @var int
     */
    protected $quantity;

    /**
     * Create a new AddItem instance.
     *
     * @param CartInterface $cart
     * @param               $item
     * @param int           $quantity
     */
    public function __construct(CartInterface $cart, $item, $quantity = 1)
    {
        $this->cart     = $cart;
        $this->item     = $item;
        $this->quantity = $quantity;
    }

    /**
     * Handle the command.
     *
     * @throws \Exception
     */
    public function handle(SaleitemRepositoryInterface $items)
    {
        if ($this->item) {
            // if (!$this->item->isPurchasable()) {
            //     throw new \Exception('Item is not purchasable at this time.');
            // }

            /* @var ItemInterface|EloquentModel $item */
            // if ($item = $this->cart->getItems()->findBy('sku', $this->item->getPurchasableSku())) {

            //     $this->dispatch(new ProcessSaleitem($item));

            //     $items->save($item->setAttribute('quantity', $item->getQuantity() + $this->quantity));

            //     return;
            // }
            $items->save(
                $item = new SaleitemModel(
                    [
                        'cart'     => $this->cart,
                        'quantity' => $this->quantity,
                        'entry'    => $this->item,
                        'price'    => $this->item->price,
                        'name'     => $this->item->name,
                    ]
                )
            );

            $this->dispatch(new ProcessSaleitem($item));

            $items->save($item);
            return;
        }

        $items->save(
            $item = new SaleitemModel(
                array_merge(
                    [
                        'cart'     => $this->cart,
                        'quantity' => $this->quantity,
                    ],
                    $this->item
                )
            )
        );

        $this->dispatch(new ProcessSaleitem($item));

        $items->save($item);
    }
}
