<?php namespace Visiosoft\CartsModule\Modifier\Command;

use Visiosoft\CartsModule\Modifier\Contract\ModifierInterface;

/**
 * Class SetCart
 *
 * @link   http://openclassify.com/
 * @author OpenClassify, Inc. <support@openclassify.com>
 * @author Visiosoft Inc <support@openclassify.com>
 */
class SetCart
{

    /**
     * The modifier instance.
     *
     * @var ModifierInterface
     */
    protected $modifier;

    /**
     * Create a new SetCart instance.
     *
     * @param ModifierInterface $modifier
     */
    public function __construct(ModifierInterface $modifier)
    {
        $this->modifier = $modifier;
    }

    /**
     * Handle the command.
     */
    public function handle()
    {
        if ($this->modifier->getCart()) {
            return;
        }

        if (!$item = $this->modifier->getItem()) {
            return;
        }

        $this->modifier->setAttribute('cart_id', $item->getCartId());
    }
}
