<?php namespace Visiosoft\CartsModule\Saleitem;

use Visiosoft\CartsModule\Saleitem\Contract\SaleitemRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class SaleitemRepository extends EntryRepository implements SaleitemRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var SaleitemModel
     */
    protected $model;

    /**
     * Create a new SaleitemRepository instance.
     *
     * @param SaleitemModel $model
     */
    public function __construct(SaleitemModel $model)
    {
        $this->model = $model;
    }

    public function getQuantity($quantity, $type, $item)
    {
        $oldQuantity = $item->getAttribute('quantity');
        if ($type == "minus") {
            return $oldQuantity - 1;
        } elseif ($type == "plus") {
            return $oldQuantity + 1;
        } else {
            return $quantity;
        }
    }

    /**
     * @param $id
     * @return mixed|void
     */
    public function deleteForCart($id)
    {
        $this->newQuery()->where('cart_id',$id)->delete();
    }

}
