<?php namespace Visiosoft\CartsModule\Http\Controller\Admin;

use Visiosoft\CartsModule\Cart\Contract\CartRepositoryInterface;
use Visiosoft\CartsModule\Cart\Form\CartFormBuilder;
use Visiosoft\CartsModule\Cart\Table\CartTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\CartsModule\Cart\Event\CartAbandoned;

class CartsController extends AdminController
{
    public function index(CartTableBuilder $table)
    {
        return $table->render();
    }

    public function create(CartFormBuilder $form)
    {
        return $form->render();
    }

    public function edit(CartFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function viewCartItems($id, CartRepositoryInterface $cartRepository)
    {
        $cart = $cartRepository->find($id);
        if (!$cart) {
            $this->messages->error(trans('visiosoft.module.carts::message.cart_not_found'));
            return redirect('admin/carts');
        }

        $cartItems = $cart->items;

        $this->template->set('show_banner', true);

        return $this->view->make(
            'module::admin/carts/view-cart-items', [
                'items' => $cartItems,
            ]
        );
    }

    public function notifyAbandonedCart($cartID, CartRepositoryInterface $cartRepository)
    {
        try {
            if (!$cart = $cartRepository->find($cartID)) {
                throw new \Exception(trans('visiosoft.module.carts::message.cart_not_found'));
            }

            if (!$cart->user) {
                throw new \Exception(trans('visiosoft.module.carts::message.customer_not_found'));
            }

            if (!count($cart->items)) {
                throw new \Exception(trans('visiosoft.module.carts::message.cart_is_empty'));
            }

            event(new CartAbandoned($cart->user, route('visiosoft.module.carts::cart')));

            $this->messages->success(trans('visiosoft.module.carts::message.user_notified_successfully'));
        } catch (\Exception $e) {
            $this->messages->error($e->getMessage());
        }

        return redirect('admin/carts');
    }
}
