<?php namespace Visiosoft\CartsModule;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;

class CartsModuleSeeder extends Seeder
{
    public function run()
    {
        // Reference notification mail template
        if (is_module_installed('visiosoft.module.notifications')) {

            $template_repo = app(TemplateRepositoryInterface::class);
            $template = $template_repo->findBySlug('abandoned_cart');
            if (!$template) {
                $template_repo->create([
                    'en' => [
                        'message' => '
                            <h1>THERE IS SOMETHING IN YOUR CART</h1>
                            <p>Would you like to complete your purchase?</p>
                            <p><a href="{url}">Check your items here!</a><br></p>
                        ',
                        'name' => 'Abandoned Cart',
                        'greeting' => 'Hello',
                        'subject' => 'Finish your purchase'
                    ],
                    'slug' => 'abandoned_cart',
                    'stream' => 'carts'
                ]);
            }
        }
    }
}
