<?php namespace Visiosoft\CartsModule\Cart\Command;

use Visiosoft\CartsModule\Cart\CartManager;
use Visiosoft\CartsModule\Cart\Contract\CartInterface;

/**
 * Class GetCart
 *
 * @link          http://openclassify.com/
 * @author        OpenClassify, Inc. <support@openclassify.com>
 * @author        Visiosoft Inc <support@openclassify.com>
 * @package       Visiosoft\CartsModule\Cart\Command
 */
class GetCart
{

    /**
     * The cart instance.
     *
     * @var string
     */
    protected $instance;

    /**
     * Create a new GetCart instance.
     *
     * @param null $instance
     */
    public function __construct($instance = null)
    {
        $this->instance = $instance;
    }

    /**
     * Handle the command.
     *
     * @param CartManager $instance
     * @return CartInterface
     */
    public function handle(CartManager $manager)
    {
        return $manager->cart($this->instance);
    }
}
