<?php namespace Visiosoft\CartsModule\Cart;

use Anomaly\Streams\Platform\Image\Command\MakeImageInstance;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CartsModule\Cart\Contract\CartInterface;
use Anomaly\Streams\Platform\Entry\EntryPresenter;
use Illuminate\Session\Store;
use Visiosoft\CartsModule\Http\Controller\CartsController;

/**
 * Class CartPresenter
 *
 * @link          http://openclassify.com/
 * @author        OpenClassify, Inc. <support@openclassify.com>
 * @author        Visiosoft Inc <support@openclassify.com>
 * @package       Visiosoft\CartsModule\Cart
 */
class CartPresenter extends EntryPresenter
{

    /**
     * The decorated object.
     *
     * @var CartInterface
     */
    protected $object;

    /**
     * The session store.
     *
     * @var Store
     */
    protected $session;

    /**
     * Return the status of the cart.
     *
     * @return string
     */
    public function status()
    {
        $date = $this->object->lastModified();

        if ($date->diffInMinutes() < 15) {
            return 'active';
        }

        if ($date->diffInMinutes() < 60) {
            return 'stale';
        }

        return 'abandoned';
    }

    /**
     * Return the status label.
     *
     * @param string $size
     * @return string
     */
    public function label($text = null, $context = null, $size = null)
    {
        if (!$text) {
            switch ($this->status()) {
                case 'active':
                    return parent::label('visiosoft.module.carts::status.active', 'success', $size);
                    break;

                case 'stale':
                    return parent::label('visiosoft.module.carts::status.stale', 'warning', $size);
                    break;

                case 'abandoned':
                    return parent::label('visiosoft.module.carts::status.abandoned', 'default', $size);
                    break;
            }

            return parent::label('anomaly.module.cart::status.abandoned', 'secondary', $size);
        }

        return parent::label($text, $context, $size);
    }

    public function getCart()
    {
        $advModel = new AdvModel();

        $cart = $this->dispatch(new GetCart());
        foreach ($cart->items as $index => $ad) {
            foreach ($cart->items as $index => $ad) {
                if ($ad->entry_type == 'Visiosoft\AdvsModule\Adv\AdvModel') {
                    $cart->items[$index]->detail_url = $advModel->getAdvDetailLinkByAdId($ad->entry_id);
                    $cart->items[$index]->cover_photo = $advModel->GetAdsDefaultCoverImageByAdId($ad->entry_id);
                } else {
                    $cart->items[$index]->cover_photo = $this->dispatch(new MakeImageInstance('theme::images/no-image-ads.jpg', 'img'))->url();
                    $cart->items[$index]->detail_url = "#";
                }
            }
        }
        return $cart;
    }
}
