<?php namespace Visiosoft\CartsModule\Modifier;

use Visiosoft\CartsModule\Modifier\Command\SetCart;
use Visiosoft\CartsModule\Modifier\Contract\ModifierInterface;
use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Entry\EntryObserver;

/**
 * Class ModifierObserver
 *
 * @link   http://openclassify.com/
 * @author OpenClassify, Inc. <support@openclassify.com>
 * @author Visiosoft Inc <support@openclassify.com>
 */
class ModifierObserver extends EntryObserver
{

    /**
     * Run before a record is created.
     *
     * @param EntryInterface|ModifierInterface $entry
     */
    public function creating(EntryInterface $entry)
    {
        $this->dispatch(new SetCart($entry));

        parent::creating($entry);
    }
}
