<?php namespace Visiosoft\CartsModule;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;

class CartsModuleSeeder extends Seeder
{
    private $templateRepository;

    public function __construct(TemplateRepositoryInterface $templateRepository)
    {
        parent::__construct();
        $this->templateRepository = $templateRepository;
    }

    public function run()
    {
        // Reference notification mail template
        if (is_module_installed('visiosoft.module.notifications')) {
            $template = $this->templateRepository->findBySlug('abandoned_cart');
            if (!$template) {
                $this->templateRepository->create([
                    'en' => [
                        'message' => '
                            <h1>THERE IS SOMETHING IN YOUR CART</h1>
                            <p>Would you like to complete your purchase?</p>
                            <p><a href="{url}">Check your items here!</a><br></p>
                        ',
                        'name' => 'Abandoned Cart',
                        'greeting' => 'Hello',
                        'subject' => 'Finish your purchase'
                    ],
                    'slug' => 'abandoned_cart'
                ]);
            }
        }
    }
}
