<?php namespace Visiosoft\CartsModule\Saleitem;

use Visiosoft\CartsModule\Saleitem\Contract\SaleitemInterface;
use Illuminate\Contracts\Container\Container;

/**
 * Class ItemProcessor
 *
 * @link   http://openclassify.com/
 * @author OpenClassify, Inc. <support@openclassify.com>
 * @author Visiosoft Inc <support@openclassify.com>
 */
class SaleitemProcessor
{

    /**
     * The configured processors.
     *
     * @var array
     */
    protected $processors = [];

    /**
     * The service container.
     *
     * @var Container
     */
    protected $container;

    /**
     * Create a new CartProcessor instance.
     *
     * @param Container $container
     */
    public function __construct(Container $container)
    {
        $this->container = $container;
    }

    /**
     * Process the item.
     *
     * @param ItemInterface $item
     */
    public function process(SaleitemInterface $item)
    {
        foreach (array_filter($this->processors) as $processor) {
            $this->container->call(
                $processor,
                [
                    'target' => $item,
                ],
                'process'
            );
        }
    }

    /**
     * Get the processors.
     *
     * @return array
     */
    public function getProcessors()
    {
        return $this->processors;
    }

    /**
     * Set the processors.
     *
     * @param array $processors
     * @return $this
     */
    public function setProcessors(array $processors)
    {
        $this->processors = $processors;

        return $this;
    }

    /**
     * Add a processor.
     *
     * @param $processor
     * @return $this
     */
    public function addProcessor($processor)
    {
        $this->processors[] = $processor;

        return $this;
    }
}
