<?php namespace Visiosoft\CartsModule\Cart\CustomerInformationForm;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Support\Facades\Cookie;
use Anomaly\Streams\Platform\Message\MessageBag;
use Illuminate\Support\Str;
use Visiosoft\ProfileModule\Adress\Contract\AdressRepositoryInterface;

class CustomerInformationFormHandler
{
    public function handle(CustomerInformationFormBuilder $builder, UserRepositoryInterface $userRepository, AdressRepositoryInterface $addressRepository)
    {
        if (!$builder->canSave()) {
            return;
        }

        //User Save
        $user_parameters = [
            'first_name' => $builder->getPostValue('first_name'),
            'last_name' => $builder->getPostValue('last_name'),
            'display_name' => $builder->getPostValue('first_name'),
            'email' => $builder->getPostValue('email'),
            'password' => Str::random(10),
            'username' => Str::slug($builder->getPostValue('email')),
            'gsm_phone' => $builder->getPostValue('phone')
        ];

        if (!$user = $userRepository->findByEmail($user_parameters['email'])) {
	        if (!$user->isActivated()) {
		        $user = $userRepository->create($user_parameters);
	        } else {
		        app(MessageBag::class)->error(trans('visiosoft.module.carts::message.user_is_active'));
		        $builder->setFormResponse(redirect(route('visiosoft.module.carts::auth_costumer')));
	        }
        }

        //Address Save
        $address_parameters = [
            'user_id' => $user->getId(),
            'adress_name' => $builder->getPostValue('address_name'),
            'adress_first_name' => $user_parameters['first_name'],
            'adress_last_name' => $user_parameters['last_name'],
            'country' => $builder->getPostValue('country'),
            'city' => $builder->getPostValue('city'),
            'district' => $builder->getPostValue('district'),
            'adress_content' => $builder->getPostValue('address'),
            'adress_gsm_phone' => $user_parameters['gsm_phone'],
        ];

        $address = $addressRepository->create($address_parameters);

        //Save Address Cookie
        Cookie::queue(Cookie::make('bill', $address->getId(), 84000));
        Cookie::queue(Cookie::make('delivery', $address->getId(), 84000));
        Cookie::queue(Cookie::make('customer', $user->getId(), 84000));
    }
}
