function getInput(field) {
    var row = field.parent().parent();
    return $(row).find('input[name="quantity"]');
}

//plus
$('.quantity-plus-btn').on('click', function () {
    var input = getInput($(this));
    updatePrice(input, 'plus')
})

//minus
$('.quantity-minus-btn').on('click', function () {
    var input = getInput($(this));
    updatePrice(input, 'minus')
})

//change
$('input[name="quantity"]').on('change', function () {
    updatePrice(this, 'change')
})

$('select[name="configuration"]').on('change', function () {
    $(this).parent().parent().parent().find('input[name="quantity"]')
        .attr('data-id', $(this).val())
        .val(1)
    updatePrice(this, 'change')
})

function updatePrice(input, type) {
    var ad_id = $(input).attr('data-id');
    var dataType = $(input).attr('data-type');
    var current_quantity = $(input).val();

    productDetail(ad_id, current_quantity, type, dataType, function (data) {
        ChangeFieldForResponse(type, data.newPrice, data.newQuantity, data.maxQuantity)
    });

}

function productDetail(id, quantity, type, dataType, returnData) {
    if (quantity == 0) {
        quantity = 1;
    }
    $.ajax({
        type: 'POST',
        url: '/ajax/StockControl',
        data: 'id=' + id + '&quantity=' + quantity + '&type=' + type + '&dataType=' + dataType,
        success: function (data) {
            returnData(data);
        }
    });
}

function ChangeFieldForResponse(type, price, quantity, maxQuantity) {
    if (parseInt(quantity) == 1) {
        $('.quantity-minus-btn').attr('disabled', true);
    } else {
        $('.quantity-minus-btn').attr('disabled', false);
    }
    if (quantity == maxQuantity) {
        $('.quantity-plus-btn').attr('disabled', true);
    } else {
        $('.quantity-plus-btn').attr('disabled', false);
    }
    $('input[name="quantity"]').val(parseInt(quantity));
    $('.ad-price b').html(price)
}

$('.add-cart-button').on('click', function () {
    var quantity = $('input[name="quantity"]').val();
    var id = $('input[name="quantity"]').attr('data-id');
    var name = $('select[name="option"]').val();
    name = name ? name : null;
    return addCart(id, quantity, name)
})

function addCart(id, quantity, name = null) {
    let data = 'id=' + id + '&quantity=' + quantity;
    data = name ? data + '&name=' + name : data;
    $.ajax({
        type: 'POST',
        url: '/ajax/addCart',
        data: data,
        success: function (data) {
            if (data.status == "success") {
                window.location.href = "/cart";
            } else {
                alert(data.msg);
            }
        }
    });
}