phoneMask("input[name='adress_gsm_phone']")

$('.add-ajax-address').on('click', function () {
    resetForm();
    //Set Create Form Action
    $("#cart-address").attr("action", '/profile/adress/ajaxCreate');

    //Set Default Country And List City
    $('select[name="country"]').val(default_country)
    if (default_country != "") {
        var cat = default_country;
        var level = 1;
        var name = 'city';
        Locations(cat, level, name);
    }

})

$("#cart-address").submit(function (e) {

    e.preventDefault(); // avoid to execute the actual submit of the form.
    var form = $(this);
    var url = form.attr('action');

    $.ajax({
        type: "POST",
        url: url,
        data: form.serialize(), // serializes the form's elements.
        success: function (response) {
            if (response.status == "success") {
                $('select[name="delivery_address"]').find('option:selected').removeAttr('selected');
                $('select[name="bill_address"]').find('option:selected').removeAttr('selected');
                var option = '<option value="' + response.data.id + '" selected>' + response.data.adress_name + '</option>';
                $('select[name="delivery_address"]').append(option);
                $('select[name="bill_address"]').append(option);
                $('#addAddress').modal('hide');
                resetForm();
                $('.edit-this-address').show();
            } else if (response.status == "updated") {
                $('.delivery_address option[value="' + response.data.id + '"]').html(response.data.adress_name)
                $('.bill_address option[value="' + response.data.id + '"]').html(response.data.adress_name)
                $('#addAddress').modal('hide');
                resetForm();
            } else {
                alert(response.msg)
            }
        }
    });
});
$(document).ready(function () {
    var default_address = $('select[name="bill_address"]');
    if (default_address.val() == null) {
        $('#addAddress').modal('show')
        //Set Default Country And List City
        $('select[name="country"]').val(default_country)
        if (default_country != "") {
            var cat = default_country;
            var level = 1;
            var name = 'city';
            Locations(cat, level, name);
        }
    } else {
        // Show the edit button
        $('.edit-this-address').show();
    }

    var ckbox = $('.same-address input');

    ckbox.on('click', function () {
        if (ckbox.is(':checked')) {
            $('.bill_address').css({'opacity': '0.5', 'filter': 'alpha(opacity=50)'});
            $('.bill_address').find('select').attr('disabled', true)
        } else {
            $('.bill_address').css({'opacity': '1', 'filter': 'none'});
            $('.bill_address').find('select').attr('disabled', false)
        }
    });

    $('select[name="delivery_address"]').on('change', function () {
        if (ckbox.is(':checked')) {
            $('select[name="bill_address"]').val($(this).val())
        }
    })
});

//Edit Address Modal Get Field Value
$('.edit-this-address').on('click', function () {
    var edit_address_id = $(this).parent().find('select').val();

    if (edit_address_id) {
        resetForm();

        //Set Update Form Action
        $("#cart-address").attr("action", '/profile/adress/ajaxUpdate/' + edit_address_id);

        //Get Address Detail
        crudAjax({"id": edit_address_id}, '/profile/adress/ajaxDetail', 'POST', function (callback) {
            var address_detail = callback.data;
            var address_field = ['adress_name', 'adress_gsm_phone', 'adress_first_name', 'adress_last_name'];

            //Each Value for Fields
            $.each(address_field, function (index, field) {
                $('input[name="' + field + '"]').val(address_detail[field])
            });

            var iti = intlTelInput(document.querySelector("input[name='adress_gsm_phone']"), {
                setNumber: address_detail.adress_gsm_phone
            })
            $('textarea[name="adress_content"]').html(address_detail.adress_content)
            $('select[name="country"]').val(address_detail.country_id)

            //Get City Options
            var cat = default_country;
            var level = 1;
            var name = 'city';
            Locations(cat, level, name);

            //Get District Options
            var selectedCity = new Promise(function (resolve) {
                $('select[name="city"]').val(address_detail.city)
                var cat = address_detail.city;
                var level = 2;
                var name = 'district';
                Locations(cat, level, name);
                resolve();
            });
            //Selected District
            selectedCity.then(function (categories_list) {
                $('select[name="district"]').val(address_detail.district)
            })

        })
        //Open Edit Address Modal
        $('#addAddress').modal('show')
    }
})

function resetForm() {
    $("#cart-address").trigger("reset");
    $("#cart-address").find("textarea").html('');
    $('select[name="district"]').html('')

}