<?php namespace Visiosoft\CartsModule\Cart\Traits;


use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CouponModule\Code\Command\calculateTotalWithCouponCode;

trait calculateTotal
{
    use DispatchesJobs;

    public function calculateTotal()
    {
        $cart = $this->dispatch(new GetCart());

        if ($couponCode = request()->cookie('coupon_code')) {
            $discount = $this->dispatch(new calculateTotalWithCouponCode($couponCode));
        } else {
            $discount = $this->dispatch(new \Visiosoft\CouponModule\Code\Command\calculateTotal($couponCode));
        }

        $total = $cart->total - $discount;

        return ['total' => $total, 'discount' => $discount, 'couponCode' => $couponCode];
    }
}