<?php namespace Visiosoft\CartsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CartsModule\Cart\CartModel;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CartsModule\Cart\Contract\CartInterface;
use Visiosoft\CartsModule\Cart\Contract\CartRepositoryInterface;
use Visiosoft\CartsModule\Saleitem\Contract\SaleitemRepositoryInterface;


class AjaxController extends PublicController
{

    private $cartRepository;
    private $cartModel;
    private $saleitemRepository;
    private $advRepository;

    public function __construct(
        CartRepositoryInterface $cartRepository,
        CartModel $cartModel,
        SaleitemRepositoryInterface $saleitemRepository,
        AdvRepositoryInterface $advRepository
    )
    {
        $this->cartRepository = $cartRepository;
        $this->cartModel = $cartModel;
        $this->saleitemRepository = $saleitemRepository;
        $this->advRepository = $advRepository;
        parent::__construct();
    }

    public function addCart(): \Illuminate\Http\JsonResponse
    {
        $quantity = $this->request->data['quantity'] ?? 1;

        $adv = $this->advRepository->find($this->request->data['item_id']);
        $this->cartModel->add($adv, $quantity);
        $cart = $this->dispatch(new GetCart());
        $cart_item = $cart->items;

        return $this->response->json(['status' => true, 'cart'=> $cart, 'cart_item' => $cart_item], 200);
    }

    public function updateCart(): \Illuminate\Http\JsonResponse
    {
        if ($cart_item = $this->saleitemRepository->find($this->request->data['item_id'])) {
            $cart_item->quantity = $this->request->data['quantity'];
            $update = $cart_item->save();
            $cart = $this->cartRepository->find($cart_item->cart_id);

            if ($update) {
                return $this->response->json(['status' => true, 'cart'=> $cart, 'cart_item' => $cart_item], 200);
            }
            return $this->response->json(['status' => false], 405);
        }
        return $this->response->json(['status' => false], 404);
    }

    public function removeCart(): \Illuminate\Http\JsonResponse
    {
        if ($cart_item = $this->saleitemRepository->find($this->request->data['item_id'])) {
            $cart_id = $cart_item->cart_id;
            $item = $cart_item->delete();
            $cart = $this->cartRepository->find($cart_id);

            if ($item) {
                return $this->response->json(['status' => true, 'cart' => $cart, 'items' => $cart->items], 200);
            }
            return $this->response->json(['status' => false], 405);
        }
        return $this->response->json(['status' => false], 404);
    }
}
