<?php namespace Visiosoft\CartsModule\Cart;

use Carbon\Carbon;
use Visiosoft\CartsModule\Cart\Contract\CartInterface;
use Visiosoft\CartsModule\Cart\Contract\CartRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class CartRepository extends EntryRepository implements CartRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var CartModel
     */
    protected $model;

    /**
     * Create a new CartRepository instance.
     *
     * @param CartModel $model
     */
    public function __construct(CartModel $model)
    {
        $this->model = $model;
    }

    /**
     * Find a cart by it's string ID.
     *
     * @param $id
     * @return null|CartInterface
     */
    public function findByStrId($id)
    {
        return $this->model->where('str_id', $id)->first();
    }

    public function getRecentAbandonedCarts()
    {
        return $this->model
            ->whereDate('created_at', Carbon::yesterday())
            ->get();
    }
}
