<?php namespace Visiosoft\CartsModule\Cart\Listener;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;
use Visiosoft\PaymentPaytrExtension\Event\PaymentResult;
use Visiosoft\OrdersModule\Http\Traits\TransactionTrait;

/**
 * Class AddToCart
 *
 * @link   http://openclassify.com/
 * @author OpenClassify, Inc. <support@openclassify.com>
 * @author Visiosoft Inc <support@openclassify.com>
 */
class PayTrHandler
{
    use DispatchesJobs;

    use TransactionTrait;


    private $orderRepository;
    public function __construct(OrderRepositoryInterface $orderRepository)
    {
        $this->orderRepository = $orderRepository;
    }
    public function handle(PaymentResult $event)
    {
        $status = $event->getPaymentStatus();

        $order_id = $event->getPaymentID();

        if ($status = 'success'){
            $this->orderRepository->approveOrder($order_id);
            $message = trans('visiosoft.module.carts::message.payment_approved');
        }else if ($status = 'fail'){
            $this->orderRepository->rejectOrder($order_id);
            $message = trans('visiosoft.module.carts::message.payment_rejected');
        }



        $this->logTransaction([
            'payment_type' => 'paytr',
            'message' => $message,
            'success' => $status ? 1 : 0,
            'payment_order' => $order_id,
        ]);

    }
}
