<?php namespace Visiosoft\CartsModule\Http\Controller\Admin;

use Visiosoft\CartsModule\Cart\Contract\CartRepositoryInterface;
use Visiosoft\CartsModule\Cart\Form\CartFormBuilder;
use Visiosoft\CartsModule\Cart\Table\CartTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class CartsController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param CartTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(CartTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param CartFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(CartFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param CartFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(CartFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function viewCartItems($id, CartRepositoryInterface $cartRepository)
    {
        $cart = $cartRepository->find($id);
        if (!$cart) {
            $this->messages->error(trans('visiosoft.module.carts::message.cart_not_found'));
            return redirect('admin/carts');
        }

        $cartItems = $cart->items;

        $this->template->set('show_banner', true);

        return $this->view->make(
            'module::admin/carts/view-cart-items', [
                'items' => $cartItems,
            ]
        );
    }
}
