function getInputForDataID(data_id) {
    return $('.quantity[data-id="' + data_id + '"]');
}

function getProductRow(id) {
    return $('.cart-item[data-id="' + id + '"]');
}

/*Change*/
$('input[name="quantity"]').on('change', function () {
    var input = $(this);
    updateQuantity(input, 'change', $(this).attr('data-id'));
})


$('.quantity-plus-btn').on('click', function () {
    $(this).attr("disabled",true);
    var input = getInputForDataID($(this).attr('data-id'));
    updateQuantity(input, 'plus', $(this).attr('data-id'));
})


$('.quantity-minus-btn').on('click', function () {
    $(this).attr("disabled",true);
    var input = getInputForDataID($(this).attr('data-id'));
    updateQuantity(input, 'minus', $(this).attr('data-id'));
})


function changeDataID(id, Row) {
    $(Row).attr('data-id', id);
    $(Row).find('.quantity, .quantity-plus-btn, .quantity-minus-btn, .remove-btn').attr('data-id', id)
}


$('.remove-btn').click(function () {
    var row = getProductRow($(this).attr('data-id'))
    removeRow(row);
});


/* Update quantity */
function updateQuantity(quantityInput, type, id) {
    /* Calculate line price */
    var productRow = getProductRow(id)
    var cartId = id;
    var quantity = quantityInput.val();

    if (parseInt(quantity) == 0 || quantity == "") {
        var res = confirm(confirmMessage);
        if (res == true) {
            removeItem(cartId)
            productRow.remove();
        } else {
            productDetail(cartId, 1, type, function (data) {
                if (data.msg == "success") {
                    Responsesuccess(data, quantityInput, productRow)
                }
            });
        }
    } else {
        productDetail(cartId, quantity, type, function (data) {

            if (data.msg == "success") {
                Responsesuccess(data, quantityInput, productRow)
            } else if (data.msg == "error1") {
                //uyarıyı bas ve maksimum adeti kaydet
                alert(data.msgContent);//stok mesajını bas
                if (data.adv.stock == 0) {
                    productRow.remove();
                    removeItem(cartId)

                } else {
                    productDetail(cartId, data.adv.stock, type, function (data) {

                        if (data.msg == "success") {
                            Responsesuccess(data, quantityInput, productRow)
                        }
                    });
                }
            } else {
                location.reload();
            }
        });
    }
}

function Responsesuccess(data, quantityInput, productRow) {
    quantityInput.val(data.cartItem.quantity);
    if (parseInt(data.cartItem.quantity) == 1) {
        $(productRow).find('.quantity-minus-btn').attr('disabled', true);
    } else if (parseInt(data.cartItem.quantity) > 1) {
        $(productRow).find('.quantity-minus-btn').attr('disabled', false);
    }

    $(productRow).find('.item-price').html(data.cartItem.currency_subtotal);
    changeDataID(data.cartItem.id, productRow)
    $('.subtotal-price').html(data.cart.currency_subtotal);
    $('.total-price').html(data.cart.currency_total);
    if (data.cart.coin_total_price) {
        $('.coin-total-price').html(data.cart.coin_total_price.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ","));
    }
    if (!data.cart.shipping) {
        $('.shipping-cart').html(free_shipping);
    } else {
        $('.shipping-cart').html(data.cart.currency_shipping);
    }
    if (!data.cart.tax) {
        $('.tax-cart').html(free_shipping);
    } else {
        $('.tax-cart').html(data.cart.tax);
    }
    $('.quantity-plus-btn').attr('disabled', false);
}



/* Remove item from cart */
function removeRow(row) {
    var productRow = row;
    var cartId = parseInt($(productRow).attr('data-id'));
    /* Remove row from DOM and recalc cart total */
    productRow.fadeOut(500, function () {
        productRow.remove();
        removeItem(cartId)
    });
}

function removeItem(cartId) {
    productDetail(cartId, 0, 'remove', function (data) {

        if (data.msg == "success") {
            if (parseInt(data.cart.subtotal) == 0) {
                window.location.reload();
            }
            $('.subtotal-price').html(data.cart.subtotal);
            $('.total-price').html(data.cart.total);
            window.location.reload();
        }
    });
}

function productDetail(id, quantity, type, returnData) {
    $.ajax({
        type: 'POST',
        url: '/cart/quantity',
        data: 'id=' + id + '&quantity=' + quantity + '&type=' + type + '&currency=1',
        success: function (data) {
            returnData(data);
        }
    });
}
