<?php namespace Visiosoft\CartsModule\Cart\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Visiosoft\CartsModule\Cart\Table\Handler\Delete;

class CartTableBuilder extends TableBuilder
{
    protected $columns = [
        'id' => 'entry.id',
        'entry.last_modified' => [
            'sort_column' => 'updated_at',
        ],
        'ip_address',
        'entry.items.quantity',
        'user_name' => [
            'value' => 'entry.user.name ?: "Guest"'
        ],
        'user_gsm_phone' => [
            'value' => 'entry.user.gsm_phone ?: "Guest"'
        ],
        'user_email' => [
            'value' => 'entry.user.email ?: "Guest"'
        ],
    ];

    protected $buttons = [
        'view_items' => [
            'type' => 'info',
            'href' => 'admin/carts/view-cart-items/{entry.id}',
        ],
        'notify' => [
            'icon' => 'fa fa-bell-o',
            'type' => 'warning',
            'href' => 'admin/carts/notify-abandoned-cart/{entry.id}',
        ],
    ];

    protected $actions = [
        'delete' => [
            'handler'=> Delete::class
        ],
    ];

    protected $options = [
        'order_by' => [
            'updated_at' => 'DESC',
        ],
    ];
}