//Phone Field
phoneMask("input[name='phone']");

//Address Area

getCountries()
    .then(function () {
        return getCities($('select[name="country"]').val());
    });

function getCountries() {
    return crudAjax('', '/ajax/getCountry', 'GET', function (callback) {
        $('select[name="country"]').html("<option>...</option>");
        $.each(callback, function (index, value) {
            var selected = (value.abv.toLowerCase() == app_locale) ? 'selected' : '';
            $('select[name="country"]').append("<option " + selected + " value='" + value.id + "'>" + value.name + "</option>");
        });
    }, true)
}

function getCities(country) {
    const selectsInput = $('select[name=city], select[name=district]')
    selectsInput.prop('disabled', true)

    $('select[name="district"]').html("<option value=''>...</option>");

    return crudAjax(`id=${country}`, '/ajax/getCities', 'POST', () => {
    }, true)
        .then(function (cities) {
            $('select[name="city"]').html("<option value=''>...</option>");
            $.each(cities, function (index, value) {
                $('select[name="city"]').append("<option value='" + value.id + "'>" + value.name + "</option>");
            });
            selectsInput.prop('disabled', false)
        })
}

function getDistricts(city) {
    const selectDistrictInput = $('select[name=district]');
    selectDistrictInput.prop('disabled', true)

    return crudAjax(`id=${city}`, '/ajax/getDistricts', 'POST', () => {
    }, true)
        .then(function (districts) {
            $('select[name="district"]').html("<option value=''>...</option>");
            $.each(districts, function (index, value) {
                $('select[name="district"]').append("<option value='" + value.id + "'>" + value.name + "</option>");
            });
            selectDistrictInput.prop('disabled', false)
        })
}

$('select[name="country"]').on('change', function () {
    getCities($(this).val());
});

$('select[name="city"]').on('change', function () {
    getDistricts($(this).val());
});
