<?php namespace Visiosoft\CartsModule\Saleitem\Command;

use Visiosoft\CartsModule\Saleitem\Contract\SaleitemInterface;
use Visiosoft\CartsModule\Saleitem\SaleitemProcessor;

/**
 * Class ProcessItem
 *
 * @link   http://openclassify.com/
 * @author OpenClassify, Inc. <support@openclassify.com>
 * @author Visiosoft Inc <support@openclassify.com>
 */
class ProcessSaleitem
{

    /**
     * The item instance.
     *
     * @var ItemInterface
     */
    protected $item;

    /**
     * Create a new ProcessItem instance.
     *
     * @param ItemInterface $item
     */
    public function __construct(SaleitemInterface $item)
    {
        $this->item = $item;
    }

    /**
     * Handle the command.
     *
     * @param ItemProcessor $processor
     */
    public function handle(SaleitemProcessor $processor)
    {
        $processor->process($this->item);
    }
}
