<?php namespace Visiosoft\CartsModule\Cart\Listener;

use Visiosoft\CartsModule\Cart\CartProcessor;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Illuminate\Foundation\Bus\DispatchesJobs;

/**
 * Class ProcessCart
 *
 * @link   http://openclassify.com/
 * @author OpenClassify, Inc. <support@openclassify.com>
 * @author Visiosoft Inc <support@openclassify.com>
 */
class ProcessCart
{

    use DispatchesJobs;

    /**
     * The cart processor.
     *
     * @var CartProcessor
     */
    protected $processor;

    /**
     * Create a new ProcessCart instance.
     *
     * @param CartProcessor $processor
     */
    public function __construct(CartProcessor $processor)
    {
        $this->processor = $processor;
    }

    /**
     * Handle the event.
     */
    public function handle()
    {
        $this->processor->process($this->dispatch(new GetCart()));
    }
}
