<?php namespace Visiosoft\CartsModule\Cart\Listener;

use Visiosoft\CartsModule\Cart\Cart;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CartsModule\Cart\Contract\CartInterface;
use Visiosoft\CartsModule\Saleitem\Contract\SaleitemInterface;
use Visiosoft\CartsModule\Saleitem\Contract\SaleitemRepositoryInterface;
use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Model\EloquentModel;
use Illuminate\Foundation\Bus\DispatchesJobs;

/**
 * Class AddToCart
 *
 * @link   http://openclassify.com/
 * @author OpenClassify, Inc. <support@openclassify.com>
 * @author Visiosoft Inc <support@openclassify.com>
 */
class AddToCart
{

    use DispatchesJobs;

    /**
     * The item repository.
     *
     * @var ItemRepositoryInterface
     */
    protected $items;

    /**
     * Create a new AddToCart instance.
     *
     * @param ItemRepositoryInterface $items
     */
    public function __construct(SaleitemRepositoryInterface $items)
    {
        $this->items = $items;
    }

    /**
     * Handle the event.
     *
     * @param $event
     */
    public function handle(EntryInterface $entry, $quantity = 1)
    {
        // if (!$entry->isPurchasable()) {
        //     return;
        // }

        /* @var CartInterface $cart */
        $cart = $this->dispatch(new GetCart('default'));

        $items = $cart->getItems();

        /* @var ItemInterface|EloquentModel $item */
        if ($item = $items->findBy('sku', $entry->getPurchasableSku())) {

            $item->setAttribute('quantity', $item->getQuantity() + $quantity);

            $this->items->save($item);

            return;
        }

        $this->items->create(
            [
                'price'    => $entry->getPurchasablePrice(),
                'name'     => $entry->getPurchasableName(),
                'sku'      => $entry->getPurchasableSku(),
                'quantity' => $quantity,
                'currency'    => $entry->getPurchasableCurrency() ?: setting_value('streams::currency'),
                'product'  => $entry,
                'cart'     => $cart,
            ]
        );
    }
}
