<?php namespace Visiosoft\CartsModule\Cart\Listener;

use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CartsModule\Cart\Command\GetCartInstance;
use Visiosoft\CartsModule\Cart\Contract\CartRepositoryInterface;
use Anomaly\UsersModule\User\Event\UserWasLoggedIn;
use Illuminate\Foundation\Bus\DispatchesJobs;

/**
 * Class AddUserToCart
 *
 * @link          http://openclassify.com/
 * @author        OpenClassify, Inc. <support@openclassify.com>
 * @author        Visiosoft Inc <support@openclassify.com>
 * @package       Visiosoft\CartsModule\Cart\Listener
 */
class AddUserToCart
{

    use DispatchesJobs;

    /**
     * The cart manager.
     *
     * @var CartRepositoryInterface $carts
     */
    protected $carts;

    /**
     * Create a new AddUserToCart instance.
     *
     * @param CartRepositoryInterface $carts
     */
    public function __construct(CartRepositoryInterface $carts)
    {
        $this->carts = $carts;
    }

    /**
     * Handle the event.
     *
     * @param UserWasLoggedIn $event
     */
    public function handle(UserWasLoggedIn $event)
    {
        $cart = $this->dispatch(new GetCart());

        $this->carts->save($cart->setAttribute('user', $event->getUser()));
    }
}
