<?php namespace Visiosoft\CartsModule\Support\Command;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\DB;
use Visiosoft\CartsModule\Cart\Command\GetCart;

class CartCount
{
    use DispatchesJobs;

    protected $update;

    public function __construct($update = null)
    {
        $this->update = $update;
    }

    public function handle()
    {
        if (!request()->hasCookie('count_cart') or $this->update) {
            $cart = $this->dispatch(new GetCart());

            $cart_count = DB::table('carts_saleitems')
                ->where('cart_id', $cart->getId())
                ->count();

            Cookie::queue(Cookie::make('count_cart', $cart_count, 84000));
        }
        return request()->cookie('count_cart',0);
    }
}
