<?php namespace Visiosoft\CartsModule\Saleitem;

use Anomaly\Streams\Platform\Image\Command\MakeImageInstance;
use Illuminate\Support\Facades\Auth;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Support\Command\Currency;
use Visiosoft\CartsModule\Saleitem\Contract\SaleitemInterface;
use Anomaly\Streams\Platform\Model\Carts\CartsSaleitemsEntryModel;
use Visiosoft\CartsModule\Cart\Contract\CartInterface;
use Visiosoft\CartsModule\Saleitem\Contract\ItemInterface;
use Visiosoft\CartsModule\Modifier\ModifierCollection;
use Visiosoft\CartsModule\Modifier\ModifierModel;
use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Image\Image;
use Anomaly\Streams\Platform\Model\Carts\CartsItemsEntryModel;
use Illuminate\Database\Eloquent\Relations\HasMany;

class SaleitemModel extends CartsSaleitemsEntryModel implements SaleitemInterface
{

    protected $appends = [
        'detail_url',
        'cover_photo',
        'currency_subtotal',
        'currency_total',
    ];

    public function getDetailUrlAttribute()
    {
        $adv_model = app(AdvModel::class);

        if ($this->entry_type == "Visiosoft\AdvsModule\Adv\AdvModel") {
            return $adv_model->getAdvDetailLinkByAdId($this->entry_id);
        } elseif ($this->entry_type == "Visiosoft\AdvsModule\OptionConfiguration\OptionConfigurationModel") {
            return $adv_model->getAdvDetailLinkByAdId($this->entry->parent_adv_id);
        }
        return "#";
    }

    public function getCoverPhotoAttribute()
    {
        $adv_model = app(AdvModel::class);

        if ($this->entry_type == "Visiosoft\AdvsModule\Adv\AdvModel") {
            return $adv_model->GetAdsDefaultCoverImageByAdId($this->entry_id);
        } elseif ($this->entry_type == "Visiosoft\AdvsModule\OptionConfiguration\OptionConfigurationModel") {
            return $adv_model->GetAdsDefaultCoverImageByAdId($this->entry->parent_adv_id);
        }
        return $this->dispatch(new MakeImageInstance('visiosoft.theme.base::images/no-image.png', 'img'))->url();
    }

    /**
     * The cascading relations.
     *
     * @var array
     */
    protected $cascades = [
        'modifiers',
    ];

    /**
     * The eager loaded relations.
     *
     * @var array
     */
    protected $with = [
        //'modifiers',
    ];

    /**
     * Get the tax.
     *
     * @return float
     */
    public function getTax()
    {
        return $this->tax;
    }

    public function getCommission()
    {
        return $this->commission;
    }

    /**
     * Get the price.
     *
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * @return \Anomaly\Streams\Platform\Entry\EntryPresenter|mixed
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * Get the total.
     *
     * @return float
     */
    public function getTotal()
    {
        return $this->total;
    }

    /**
     * Get the subtotal.
     *
     * @return float
     */
    public function getSubtotal()
    {
        return $this->subtotal;
    }

    /**
     * Get the shipping.
     *
     * @return float
     */
    public function getShipping()
    {
        return $this->shipping;
    }

    /**
     * Get the discounts.
     *
     * @return float
     */
    public function getDiscounts()
    {
        return $this->discounts;
    }

    /**
     * Get the quantity.
     *
     * @return float
     */
    public function getQuantity()
    {
        return $this->quantity;
    }

    /**
     * Get the image.
     *
     * @return null|Image
     */
    public function getImage()
    {
        $entry = $this->getEntry();

        return null;
    }

    /**
     * Calculate total adjustments.
     *
     * @param $type
     * @return float
     */
    public function calculate($type)
    {
        $modifiers = $this
            ->getModifiers()
            ->type($type);

        return $modifiers->calculate($this->getSubtotal());
    }

    /**
     * Get the entry.
     *
     * @return EntryInterface
     */
    public function getEntry()
    {
        return $this->entry;
    }

    /**
     * Get the cart.
     *
     * @return CartInterface
     */
    public function getCart()
    {
        return $this->cart;
    }

    /**
     * Get the cart ID.
     *
     * @return int
     */
    public function getCartId()
    {
        return $this->cart_id;
    }

    /**
     * Get related modifiers.
     *
     * @return ModifierCollection
     */
    public function getModifiers()
    {
        return $this->modifiers;
    }

    /**
     * Return the modifiers relationship.
     *
     * @return HasMany
     */
    public function modifiers()
    {
        return $this->hasMany(ModifierModel::class, 'item_id');
    }

    /**
     * Get the options.
     *
     * @return array
     */
    public function getOptions()
    {
        return $this->options;
    }

    /**
     * Get the options attribute.
     *
     * @return array
     */
    public function getOptionsAttribute()
    {
        if (!isset($this->attributes['options'])) {
            return [];
        }

        return unserialize($this->attributes['options']);
    }

    /**
     * Set the options attribute.
     *
     * @param array $options
     * @return $this
     */
    public function setOptionsAttribute(array $options)
    {
        $this->attributes['options'] = serialize($options);

        return $this;
    }

    public function getCountCart($id)
    {
        $cart = $this
            ->where('created_by_id', Auth::id())
            ->where('cart_id', $id)
            ->get();
        return count($cart);
    }


    public function priceFormat($adv)
    {
        $advModel = new AdvModel();
        return $advModel->priceFormat($adv);
    }

    public function getCurrencySubtotalAttribute()
    {
        return app(Currency::class)->format($this->subtotal, $this->currency);
    }

    public function getCurrencyTotalAttribute()
    {
        return app(Currency::class)->format($this->total, $this->currency);
    }

}
