<?php namespace Visiosoft\CartsModule\Saleitem\Command;

use Visiosoft\AdvsModule\Adv\Command\ConvertCurrency;
use Visiosoft\CartsModule\Cart\Contract\CartInterface;
use Visiosoft\CartsModule\Saleitem\Contract\SaleitemInterface;
use Visiosoft\CartsModule\Saleitem\Contract\SaleitemRepositoryInterface;
use Visiosoft\CartsModule\Saleitem\SaleitemModel;
use Anomaly\Streams\Platform\Model\EloquentModel;
use Illuminate\Foundation\Bus\DispatchesJobs;

/**
 * Class AddItem
 *
 * @link   http://openclassify.com/
 * @author OpenClassify, Inc. <support@openclassify.com>
 * @author Visiosoft Inc <support@openclassify.com>
 */
class AddSaleitem
{

    use DispatchesJobs;

    /**
     * The cart instance.
     *
     * @var CartInterface
     */
    protected $cart;

    /**
     * The item payload.
     *
     * @var mixed
     */
    protected $item;

    /**
     * The item quantity.
     *
     * @var int
     */
    protected $quantity;

    /**
     * @var null
     */
    protected $name;

    /**
     * Create a new AddItem instance.
     *
     * @param CartInterface $cart
     * @param               $item
     * @param int $quantity
     */
    public function __construct(CartInterface $cart, $item, $quantity = 1, $name = null)
    {
        $this->cart = $cart;
        $this->item = $item;
        $this->quantity = $quantity;
        $this->name = $name;
    }

    /**
     * Handle the command.
     *
     * @throws \Exception
     */
    public function handle(SaleitemRepositoryInterface $items)
    {
        if ($this->item) {
            // if (!$this->item->isPurchasable()) {
            //     throw new \Exception('Item is not purchasable at this time.');
            // }

            $item_name = $this->item->trans_name ?? $this->item->name;
            $name = $this->name ? $item_name . ' (' . $this->name . ')' : $item_name;

            /* @var ItemInterface|EloquentModel $item */
            if ($item = $this->cart->getItems()->findBy('entry_id', $this->item->id)
                and $this->cart->getItems()->findBy('entry_type', get_class($this->item))
                and $this->cart->getItems()->findBy('name', $name)) {

                $this->dispatch(new ProcessSaleitem($item));

                $items->save($item->setAttribute('quantity', $item->getQuantity() + $this->quantity));

                return;
            }

            $currency = $this->item->currency ?: setting_value('streams::currency');
            $price =  $this->item->price;

            // Convert Currency before adding Cart
            if (setting_value('visiosoft.module.carts::auto_currency_converter')) {
                $convert = $this->dispatch(new ConvertCurrency($this->item->price, $this->item->currency, setting_value('streams::currency')));

                $price = $convert['price'];
                $currency = $convert['currency'];
            }

            $items->save(
                $item = new SaleitemModel(
                    [
                        'cart' => $this->cart,
                        'quantity' => $this->quantity,
                        'entry' => $this->item,
                        'price' => $price,
                        'name' => $name,
                        'currency' => $currency,
                    ]
                )
            );

            if ($this->item->related) {
                $item->related = $this->item->related;
                $item->save();
            }

            $this->dispatch(new ProcessSaleitem($item));

            $items->save($item);
            return;
        }

        $items->save(
            $item = new SaleitemModel(
                array_merge(
                    [
                        'cart' => $this->cart,
                        'quantity' => $this->quantity,
                    ],
                    $this->item
                )
            )
        );

        $this->dispatch(new ProcessSaleitem($item));

        $items->save($item);
    }
}
