<?php namespace Visiosoft\CartsModule\Modifier\Command;

use Visiosoft\CartsModule\Modifier\Contract\ModifierInterface;
use Visiosoft\CartsModule\Modifier\ModifierValue;

/**
 * Class ApplyModifier
 *
 * @link   http://openclassify.com/
 * @author OpenClassify, Inc. <support@openclassify.com>
 * @author Visiosoft Inc <support@openclassify.com>
 */
class ApplyModifier
{

    /**
     * The modifier instance.
     *
     * @var ModifierInterface
     */
    protected $modifier;

    /**
     * The value to apply
     * the modifier to.
     *
     * @var float
     */
    protected $value;

    /**
     * Create a new ApplyModifier instance.
     *
     * @param ModifierInterface $modifier
     * @param float $value
     */
    public function __construct(ModifierInterface $modifier, $value)
    {
        $this->value    = $value;
        $this->modifier = $modifier;
    }

    /**
     * Handle the command.
     *
     * @param ModifierValue $value
     * @return float
     */
    public function handle(ModifierValue $value)
    {
        $modification = $this->modifier->getValue();

        $delta = $value->clean($modification);

        if ($value->isPercentage($modification)) {
            if ($value->isSubtraction($modification)) {
                $result = floatval($this->value - ($this->value * ($delta / 100)));
            } else {
                $result = floatval($this->value + ($this->value * ($delta / 100)));
            }
        } else {
            if ($value->isSubtraction($modification)) {
                $result = floatval($this->value - $delta);
            } else {
                $result = floatval($this->value + $delta);
            }
        }

        return $result < 0 ? 0.00 : $result;
    }
}
