<?php namespace Visiosoft\CartsModule\Http\Controller;

use Anomaly\PagesModule\Page\PageRepository;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Image\Command\MakeImageInstance;
use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Contracts\Events\Dispatcher;
use Anomaly\Streams\Platform\Model\Dopings\DopingsDopingsEntryModel;
use Illuminate\Contracts\View\View;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Redirect;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AdvsModule\Support\Command\Currency;
use Visiosoft\BalancesModule\Balance\Contract\BalanceRepositoryInterface;
use Visiosoft\CartsModule\Cart\CartRepository;
use Visiosoft\CartsModule\Cart\Event\CartRemove;
use Visiosoft\CartsModule\Cart\Event\CartsPay;
use Visiosoft\CartsModule\Cart\Event\Payment;
use Visiosoft\CartsModule\Cart\Event\PaymentPending;
use Visiosoft\CartsModule\Cart\Event\PaymentSuccess;
use Visiosoft\CouponModule\Code\Command\calculateTotal;
use Visiosoft\CouponModule\Code\Command\calculateTotalWithCouponCode;
use Visiosoft\LocationModule\City\CityRepository;
use Visiosoft\LocationModule\Country\CountryModel;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CartsModule\Saleitem\Contract\SaleitemRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\OrdersModule\Events\OrderCreated;
use Visiosoft\OrdersModule\Order\OrderModel;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailModel;
use Visiosoft\PackagesModule\Package\PackageModel;
use Visiosoft\PackagesModule\PackageEntry\PackageEntryModel;
use Visiosoft\PackagesModule\Userentry\UserentryModel;
use Visiosoft\PaymentIyzicoModule\Http\Controller\IyzicoController;
use Visiosoft\ProfileModule\Adress\AdressModel;
use Visiosoft\ProfileModule\Adress\AdressRepository;
use Visiosoft\StoreModule\Store\StoreModel;
use Visiosoft\StoreModule\Doping\DopingModel;

class CartsController extends PublicController
{
    private $advModel;
    private $adressModel;
    private $countryModel;
    private $orderModel;
    private $orderdetailModel;
    private $currency;

    use \Visiosoft\CartsModule\Cart\Traits\calculateTotal;

    public function __construct(
        AdvModel $advModel,
        AdressModel $adressModel,
        CountryModel $countryModel,
        OrderModel $orderModel,
        OrderdetailModel $orderdetailModel,
        Currency $currency
    )
    {
        parent::__construct();
        $this->advModel = $advModel;
        $this->adressModel = $adressModel;
        $this->countryModel = $countryModel;
        $this->orderModel = $orderModel;
        $this->orderdetailModel = $orderdetailModel;
        $this->currency = $currency;
    }

    /**
     * View the contents of a cart.
     *
     * @return View|mixed
     * @throws BindingResolutionException
     */
    public function view()
    {
        $cart = $this->dispatch(new GetCart());
	    $cart['compatible'] = true;
        foreach ($cart->items as $index => $item) {
        	$item['currency'] !== setting_value('streams::currency') ? $cart['compatible'] = false : '';

            if ($item->entry_type == 'Visiosoft\AdvsModule\Adv\AdvModel') {
                $stock_control = $this->advModel->stockControl($item->entry_id, $item->quantity);
                $product_control = $this->advModel->is_active($item->entry_id);
                if ($stock_control == 0) {
                    $cart->remove($item->id); //Remove item in cart
                    $this->messages->info("'" . $item->name . "' => " . trans('visiosoft.module.carts::message.error1in1'));
                }
                if ($product_control == 0) {
                    $cart->remove($item->id); //Remove item in cart
                    $this->messages->info("'" . $item->name . "' => " . trans('visiosoft.module.carts::message.error2'));
                }

                $cart->items[$index]->detail_url = $this->advModel->getAdvDetailLinkByAdId($item->entry_id);
                $cart->items[$index]->cover_photo = $this->advModel->GetAdsDefaultCoverImageByAdId($item->entry_id);
            } else {
                $cart->items[$index]->cover_photo = $this->dispatch(new MakeImageInstance('visiosoft.theme.base::images/no-image.png', 'img'))->url();
                $cart->items[$index]->detail_url = "#";
            }
        }


        $total = $cart->total;
        $discount = 0;
        $couponCode = null;
        if (is_module_installed('visiosoft.module.coupon')) {
            $calculate = $this->calculateTotal();
            $total = $calculate['total'];
            $discount = $calculate['discount'];
            $couponCode = $calculate['couponCode'];
        }

        $this->template->set('meta_title', 'Cart');
        return $this->view->make('visiosoft.module.carts::carts.view', compact('cart', 'total', 'discount', 'couponCode'));
    }


    public function bankOrder($pay_type, $order_id)
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }

        $cart = $this->dispatch(new GetCart());

        //Stock And Product Control
        foreach ($cart->items as $item) {
            if ($item->entry_type == 'Visiosoft\AdvsModule\Adv\AdvModel') {
                $stock_control = $this->advModel->stockControl($item->entry_id, $item->quantity);
                $product_control = $this->advModel->is_active($item->entry_id);
                if ($stock_control == 0 || $product_control == 0) {
                    return route('visiosoft.module.carts::cart');
                }
            }
        }

        $items = $cart->getItems();

        foreach ($items as $item) {
            if ($item->entry_type == 'Visiosoft\BalancesModule\Balance\BalanceModel') {
                $balanceRepository = app(BalanceRepositoryInterface::class);
                $balanceCartUpdate = $balanceRepository->cartUpdate($item->entry_id, $cart, $pay_type);
                if (!$balanceCartUpdate) {
                    $result = false;
                }
            } else if ($item->entry_type == 'Visiosoft\PackagesModule\Package\PackageModel') {
                $packages = new PackageModel();
                $packages->PendingStatus($item->entry_id);
            } else if ($item->entry_type == 'Anomaly\Streams\Platform\Model\Dopings\DopingsDopingsEntryModel') {
                $doping = DopingsDopingsEntryModel::find($item->entry_id);
                $doping->status = 'pending_approve';
                $doping->save();
            } else if ($item->entry_type == 'Visiosoft\AdvsModule\Adv\AdvModel') {
                $this->advModel->updateStock($item->entry_id, $item->quantity);
            }
        }

        $cart->delete();

        $order = $this->orderModel->find($order_id);
        event(new PaymentPending($order));

        return redirect(route('orders::purchase_detail', ['id' => $order_id]));
    }

    public function fail($type = '')
    {
        $result = false;
        $cart = $this->dispatch(new GetCart());
        $message = $this->request->session()->get('message');
        if ($type == "balance") {
            $message = trans("visiosoft.module.carts::message.balancefail");
        }
        $this->messages->error($message);
        return redirect(route('visiosoft.module.carts::carts.review'));
    }

    public function success($type, Dispatcher $events, SettingRepositoryInterface $settings)
    {
        $cart = $this->dispatch(new GetCart());

        $order_id = $this->request->cookie('order_id');
        $cart->delete();

        $events->dispatch(new Payment($order_id, $settings));
        $order = $this->orderModel->find($order_id);

        event(new PaymentSuccess($order));

        $this->messages->success(trans('visiosoft.module.carts::message.payment_approved'));

        return Redirect::to(url('purchase/detail/' . $order_id));
    }

    public function addOrders($items, $status, $bill, $delivery, $order_type = 'order', $customer_id = null)
    {

        $cart = $this->dispatch(new GetCart());


        $isOrdersModule = $this->advModel->is_enabled('orders');


        $total = $cart->total;
        $discount = 0;

        if (is_module_installed('visiosoft.module.coupon')) {
            $calculate = $this->calculateTotal();
            $total = $calculate['total'];
            $discount = $calculate['discount'];
            $couponCode = $calculate['couponCode'];
        }


        if ($isOrdersModule) {
            $order_id = $this->orderModel->create_orders([
                'user' => (Auth::check()) ? Auth::id() : $customer_id,
                'pay_type' => $order_type,
                'total' => $total,
                'type' => $this->getTypeSlug(array_first($items)->entry_type),//First item type
                'subtotal' => $cart->subtotal,
                'shipping' => $cart->shipping,
                'tax' => $cart->tax,
                'currency' => setting_value('streams::currency'), 'status' => $status,
                'order_at' => date('Y-m-d H:i:s'),
                'bill_address' => $bill,
                'delivery_address' => $delivery
            ]);

            foreach ($items as $item) {
                $itemType = $this->getTypeSlug($item->entry_type);
                $total = $itemType === 'adv' ? $item->total : $item->price;

                $order_detail_params = [
                    'item_id' => $item->entry_id,
                    'item_type' => $itemType,
                    'price' => $item->price,
                    'currency' => $item->currency,
                    'piece' => $item->quantity,
                    'commission' => 0,
                    'total' => $total,
                    'order' => $order_id,
                    'status' => 'awaiting_payment',
                    'notes' => $item->name
                ];

                if ($item->related) {
                    $order_detail_params['related'] = $item->related;
                }

                $this->orderdetailModel->create_datail($order_detail_params);

            }
        }

        event(new OrderCreated($order_id));

        return $order_id;
    }

    public function review_cart()
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $address = $this->adressModel->getUserAdress();
        $cart = $this->dispatch(new GetCart());


        $total = $cart->total;
        $discount = 0;

        $couponCode = null;
        if (is_module_installed('visiosoft.module.coupon')) {
            $calculate = $this->calculateTotal();
            $total = $calculate['total'];
            $discount = $calculate['discount'];
            $couponCode = $calculate['couponCode'];
        }

        $showDeliveryAddress = count($cart->getItems()->where('entry_type', 'Visiosoft\AdvsModule\Adv\AdvModel'));
        $this->template->set('meta_title', 'Cart');
        $country = $this->countryModel->all();
        $pay_type = array();
        $pay_type = event(new CartsPay($pay_type));
        return $this->view->make(
            'visiosoft.module.carts::carts.review',
            compact('cart', 'pay_type', 'country', 'address', 'showDeliveryAddress', 'discount', 'total', 'couponCode')
        );

    }

    public function send_request(Request $request)
    {
        if (!isset($request->license) and $request->license != "on") {
            return back();
        }

        Cookie::queue(Cookie::make('delivery', $request->delivery_address, 84000));
        Cookie::queue(Cookie::make('bill', $request->delivery_address, 84000));
        Cookie::queue(Cookie::make('pay', $request->pay_type, 84000));

        if ($request->has('bill_address') and $request->bill_address) {
            Cookie::queue(Cookie::make('bill', $request->bill_address, 84000));
        }

        $cart = $this->dispatch(new GetCart());
        $items = $cart->getItems();

        $bill_address = $request->bill_address;
        if (!$request->has('bill_address')) {
            $bill_address = $request->delivery_address;
        }

        $order_id = $this->addOrders(
            $items,
            'pending',
            $bill_address,
            $request->delivery_address,
            $request->pay_type
        );
        Cookie::queue(Cookie::make('order_id', $order_id, 84000));

        if ($request->pay_type == 'paypal') {
            return $this->redirect->route('visiosoft.module.payment_paypal::payment', ['order_id' => $order_id]);
        } elseif ($request->pay_type == 'iyzico') {
	        $contractPage = $this->getContractPage($request->cart, $request->refund_page, $request->delivery_address, $request->bill_address, $request->pay_type);
	        return app(IyzicoController::class)->paymentForm($contractPage);
        } elseif ($request->pay_type == 'paytr') {
            return Redirect::to(url('payment/paytr/respond'));
        } elseif ($request->pay_type == 'balance') {
            return Redirect::to(url('payment/balance'));
        } elseif ($request->pay_type == 'stripe') {
            return Redirect::to(url('payment/stripe'));
        } elseif ($request->pay_type == 'bonus') {
            return \redirect()->route('visiosoft.module.bonus::bonus_pay');
        } else {
            return $this->bankOrder($request->pay_type, $order_id);
        }
    }

    public function checkoutCustomer()
    {
        if (!$this->request->hasCookie('bill')) {
            $this->messages->error(trans('visiosoft.module.carts::message.customer_address_error'));
            return back();
        }

        $address_id = $this->request->cookie('bill');
        $customer_id = $this->request->cookie('customer');

        $cart = $this->dispatch(new GetCart());
        $items = $cart->getItems();

        //Create Order
        $order_id = $this->addOrders($items, 'pending', $address_id, $address_id, 'iyzico', $customer_id);

        //Save order Cookie
        Cookie::queue(Cookie::make('order_id', $order_id, 84000));

        return Redirect::to(url('payment/iyzico'));
    }

    public function getCart()
    {
        return $this->dispatch(new GetCart());
    }

    /**
     * Update all items in a cart.
     *
     * @param SaleitemRepositoryInterface $items
     * @param AdvRepositoryInterface $advRepository
     * @return array
     */
    public function update(SaleitemRepositoryInterface $items, AdvRepositoryInterface $advRepository)
    {
        $current_item = array();
        $id = $this->request->get('id');
        $quantity = $this->request->get('quantity');
        $type = $this->request->get('type');
        $item = $items->find($id);
        $cart = $this->dispatch(new GetCart());

        if ($type == "remove") {
            event(new CartRemove($item));

            $cart->remove($id); //Remove item in cart
            $current_item['cart'] = $this->getCart();

            if (\request()->currency) {
                $defCurr = setting_value('streams::currency');
                $current_item['cart']->total = $this->currency->format($current_item['cart']->total, $defCurr);
                $current_item['cart']->subtotal = $this->currency->format($current_item['cart']->subtotal, $defCurr);
            }

            $current_item['msg'] = "success";
            return $current_item;
        }
        //Get Quantity for Type
        $quantity = $items->getQuantity($quantity, $type, $item);

        if ($item) {
            if ($item->entry_type == "Visiosoft\AdvsModule\Adv\AdvModel") {
                //Get Adv in Cart
                $adv = $advRepository->findById($item->getAttribute('entry_id'));

                if ($adv->stock >= $quantity) {

                    $cart->remove($id); //Remove item in cart
                    $cart->add($adv, $quantity); //Add new item in cart

                    $last_item = app(SaleitemRepositoryInterface::class)->lastItem(); //Get last item in Cart;

	                $current_item['cartItem'] = $this->addCurrency($last_item, 'item');
	                $current_item['adv'] = $adv;
	                $current_item['cart'] = $this->addCurrency($this->getCart(), 'cart');
	                $current_item['msg'] = "success";
                } else {
                    $current_item['adv'] = $adv;
                    $current_item['msg'] = "error1"; //No Limit
                    if ($adv->stock == 0) {
                        $current_item['msgContent'] = trans('visiosoft.module.carts::message.error1in1'); //No Limit
                    } else {
                        $current_item['msgContent'] = trans('visiosoft.module.carts::message.error1in2'); //No Limit
                    }
                }
            } else {
                $current_item['msg'] = "error2"; //No Ads
                $current_item['msgContent'] = trans('visiosoft.module.carts::message.error2'); //No Ads
            }
        } else {
            $current_item['msg'] = "error3"; //No Cart İtem
            $current_item['msgContent'] = trans('visiosoft.module.carts::message.error3'); //No Cart İtem
        }

        return $current_item;
    }

    public function addCurrency($entry, $type)
    {
        if ($type == "item") {
            $entry['subtotal'] = $this->currency->format($entry['subtotal']);
        } else if ($type == "cart") {
            $entry['subtotal'] = $this->currency->format($entry['subtotal']);
            $entry['total'] = $this->currency->format($entry['total']);
            $entry['tax'] = ($entry['tax'] == 0) ? 0 : $this->currency->format($entry['tax']);
            $entry['shipping'] = ($entry['shipping'] == 0) ? 0 : $this->currency->format($entry['shipping']);
        }
        return $entry;
    }

    public function getTypeSlug($entry_type)
    {
        $itemType = "";
        switch ($entry_type) {
            case 'Visiosoft\BalancesModule\Balance\BalanceModel':
                $itemType = 'balance';
                break;
            case 'Visiosoft\PackagesModule\Package\PackageModel':
                $itemType = 'package';
                break;
            case 'Anomaly\Streams\Platform\Model\Dopings\DopingsDopingsEntryModel':
                $itemType = 'doping';
                break;
            case 'Visiosoft\AdvsModule\Adv\AdvModel':
                $itemType = 'adv';
                break;
            case 'Visiosoft\SiteModule\Addon\AddonModel':
                $itemType = 'site';
                break;
            case 'Visiosoft\SiteModule\Bundle\BundleModel':
                $itemType = 'bundle';
                break;
            case 'Anomaly\Streams\Platform\Model\Users\UsersUsersEntryModel':
                $itemType = 'Subscription';
                break;
            case 'Visiosoft\AdvsModule\OptionConfiguration\OptionConfigurationModel':
                $itemType = 'ads-configuration';
                break;
            case 'Visiosoft\StoreModule\Store\StoreModel':
                $itemType = 'store';
                break;
            case 'Visiosoft\StoreModule\Doping\DopingModel':
                $itemType = 'store-doping';
                break;
        }

        return $itemType;
    }

	public function getContractPage($cart, $page, $delivery_address, $bill_address, $pay_type)
	{
		$contract = [];
		$content = app(PageRepository::class)->find($page)->entry->content;
		$cart = app(CartRepository::class)->find($cart);
		$delivery_address = app(AdressRepository::class)->find($delivery_address);
		$delivery_city = app(CityRepository::class)->find($delivery_address->city)->name;
		$bill_address = app(AdressRepository::class)->find($bill_address);

		foreach ($cart->items as $item) {
			$store = app(StoreModel::class)->where('user_id', $item->entry->created_by_id)->first();
			$newContent = str_replace([
				'${seller_name}',
				'${seller_address}',
				'${seller_phone}',
				'${seller_mail}',
				'${delivery_name}',
				'${delivery_address}',
				'${delivery_phone}',
				'${delivery_mail}',
				'${buyer_name}',
				'${buyer_phone}',
				'${buyer_mail}',
				'${shipping}',
				'${total}',
				'${payment}',
				'${bill_address}',
				'${order_date}',
				'${bill_name}',
				'${bill_phone}',
				'${bill_mail}',
				'${seller}',
				'${buyer}',
				'${date}',
				'${product}',
				'${quantity}',
				'${price}',
				'${total}',
			], [
				$store ? ($store->name) : ($item->entry->created_by->first_name . ' ' . $item->entry->created_by->last_name),
				$store ? ($store->address . ' ' . $store->country->name) : '',
				$store ? ($store->land_phone) : ($item->entry->created_by->gsm_phone),
				$store ? ($store->email) : ($item->entry->created_by->email),
				$delivery_address->adress_first_name . ' ' . $delivery_address->adress_last_name,
				$delivery_address->adress_content . ' ' . $delivery_city . ' ' . $delivery_address->country->name,
				$delivery_address->adress_gsm_phone,
				Auth::user()->email,
				Auth::user()->first_name . ' ' . Auth::user()->last_name,
				Auth::user()->gsm_phone,
				Auth::user()->email,
				$cart->shipping,
				$cart->subtotal,
				$pay_type,
				$bill_address->adress_content . ' ' . $bill_address->country->name,
				now()->format('d.m.Y'),
				$bill_address->adress_first_name . ' ' . $bill_address->adress_last_name,
				$bill_address->adress_gsm_phone,
				Auth::user()->email,
				$store ? ($store->name) : ($item->entry->created_by->first_name . ' ' . $item->entry->created_by->last_name),
				Auth::user()->first_name . ' ' . Auth::user()->last_name,
				now()->format('d.m.Y'),
				$item->name,
				$item->quantity,
				$item->price,
				$item->total,
			], $content);
			$contract[$store ? ($store->slug) : ($item->entry->created_by_id)] = [
				'store_name' => $store ? ($store->name) : ($item->entry->created_by->first_name . ' ' . $item->entry->created_by->last_name),
				'content' => $newContent,
				'item' => [$item->id => $item->name]
			];
		}

		return $contract;
	}
}
