<?php namespace Visiosoft\CartsModule\Saleitem;

use Anomaly\CartsModule\Saleitem\Contract\SaleitemInterface;
use Anomaly\Streams\Platform\Entry\EntryPresenter;
use Anomaly\Streams\Platform\Traits\Hookable;
use Visiosoft\AdvsModule\Adv\AdvModel;

class SaleitemPresenter extends EntryPresenter
{

    /**
     * The decorated object.
     *
     * @var ItemInterface
     */
    protected $object;

    /**
     * Check for purchasable hook
     * attributes before delegating.
     *
     * @param string $key
     * @return mixed
     */
    public function __get($key)
    {
        if ($value = parent::__get($key)) {
            return $value;
        }

        $hook = 'get_purchasable_' . snake_case($key);

        /* @var Hookable $purchasable */
        if (!$purchasable = $this->object->getEntry()) {
            return null;
        }

        if ($purchasable->hasHook($hook)) {
            return $purchasable->{camel_case($hook)}();
        }

        return null;
    }

    public function priceFormat($adv)
    {
        $advModel = new AdvModel();
        return $advModel->priceFormat($adv->getObject());
    }
}
