<?php namespace Visiosoft\CartsModule\Http\Controller\Admin;

use Visiosoft\CartsModule\Cart\Form\CartFormBuilder;
use Visiosoft\CartsModule\Cart\Table\CartTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class CartsController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param CartTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(CartTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param CartFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(CartFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param CartFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(CartFormBuilder $form, $id)
    {
        return $form->render($id);
    }
}
