<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Visiosoft\CartsModule\Cart\CartModel;
use Visiosoft\CartsModule\Saleitem\SaleitemModel;
use Anomaly\UsersModule\User\UserModel;

class VisiosoftModuleCartsCreateCartsFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'str_id' => 'anomaly.field_type.text',
        'sku' => 'anomaly.field_type.text',
        'name' => 'anomaly.field_type.text',
        'price' => 'visiosoft.field_type.decimal',
        'total' => 'visiosoft.field_type.decimal',
        'tax' => 'visiosoft.field_type.decimal',
        'commission' => 'visiosoft.field_type.decimal',
        'shipping' => 'visiosoft.field_type.decimal',
        'subtotal' => 'visiosoft.field_type.decimal',
        'discounts' => 'visiosoft.field_type.decimal',
        'currency' => [
            'type' => 'anomaly.field_type.select',
            'config' => [
                'handler' => 'currencies',
            ],
        ],
        'instance' => [
            'type' => 'anomaly.field_type.slug',
            'config' => [
                'default_value' => 'default',
            ],
        ],
        'ip_address' => 'anomaly.field_type.text',
        'quantity' => [
            'type' => 'anomaly.field_type.integer',
            'config' => [
                'min' => 1,
            ],
        ],
        'cart' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => CartModel::class,
            ],
        ],
        'item' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => SaleitemModel::class,
            ],
        ],
        'discount_code' => 'anomaly.field_type.polymorphic',
        'user' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class,
            ],
        ],
        'type' => 'anomaly.field_type.slug',
        'value' => 'anomaly.field_type.text',
        'options' => 'anomaly.field_type.textarea',
        'entry' => 'anomaly.field_type.polymorphic',
    ];

}
