<?php namespace Visiosoft\CartsModule\Saleitem;

use Visiosoft\CartsModule\Cart\Command\ProcessCart;
use Visiosoft\CartsModule\Cart\Command\TotalCart;
use Visiosoft\CartsModule\Cart\Contract\CartInterface;
use Visiosoft\CartsModule\Saleitem\Command\TotalSaleitem;
use Visiosoft\CartsModule\Saleitem\Contract\SaleitemInterface;
use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Entry\EntryObserver;
use Anomaly\Streams\Platform\Model\EloquentModel;

class SaleitemObserver extends EntryObserver
{

    /**
     * Before saving an entry touch the
     * meta information.
     *
     * @param  EntryInterface|ItemInterface $entry
     */
    public function saving(EntryInterface $entry)
    {
        $this->dispatch(new TotalSaleitem($entry));

        parent::saving($entry);
    }

    /**
     * Run after saving a record.
     *
     * @param EntryInterface|ItemInterface $entry
     */
    public function saved(EntryInterface $entry)
    {
        /* @var CartInterface|EloquentModel $cart */
        $cart = $entry->getCart();

        $cart->load('items');

        $this->dispatch(new ProcessCart($cart));

        $cart->load('items');
        $cart->load('modifiers');

        $this->dispatch(new TotalCart($cart));

        $cart->save();

        parent::saved($entry);
    }

    /**
     * Run after a record has been deleted.
     *
     * @param EntryInterface|ItemInterface $entry
     */
    public function deleted(EntryInterface $entry)
    {
        /* @var CartInterface|EloquentModel $cart */
        $cart = $entry->getCart();

        $this->dispatch(new ProcessCart($cart));
        $this->dispatch(new TotalCart($cart));

        $cart->save();
    }
}
