<?php namespace Visiosoft\CartsModule\Http\Controller;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Image\Command\MakeImageInstance;
use Anomaly\Streams\Platform\Message\MessageBag;
use Anomaly\Streams\Platform\Model\Packages\PackagesPackagesEntryModel;
use Composer\Package\Package;
use Illuminate\Contracts\Events\Dispatcher;
use Anomaly\Streams\Platform\Model\Dopings\DopingsDopingsEntryModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;
use Rinvex\Subscriptions\Models\Plan;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CartsModule\Cart\Event\CartsPay;
use Visiosoft\CartsModule\Cart\Event\PayBankOrder;
use Visiosoft\CartsModule\Cart\Event\Payment;
use Visiosoft\LocationModule\Country\CountryModel;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CartsModule\Cart\Command\ProcessCart;
use Visiosoft\CartsModule\Saleitem\Contract\SaleitemInterface;
use Visiosoft\CartsModule\Saleitem\Contract\SaleitemRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\Streams\Platform\Model\EloquentModel;
use Visiosoft\CartsModule\Cart\CartPresenter;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\OrdersModule\Order\OrderModel;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailModel;
use Visiosoft\PackagesModule\Package\PackageModel;
use Visiosoft\PackagesModule\PackageEntry\PackageEntryModel;
use Visiosoft\PackagesModule\User\UserModel;
use Visiosoft\PackagesModule\Userentry\UserentryModel;
use Visiosoft\ProfileModule\Adress\AdressModel;
use Visiosoft\SubscriptionsModule\Subscription\SubscriptionModel;

/**
 * Class CartsController
 *
 * @link          http://openclassify.com/
 * @author        OpenClassify, Inc. <support@openclassify.com>
 * @author        Visiosoft Inc <support@openclassify.com>
 * @package       Visiosoft\CartsModule\Http\Controller
 */
class CartsController extends PublicController
{

    /**
     * View the contents of a cart.
     *
     * @param string $instance
     * @return \Illuminate\Contracts\View\View|mixed
     */
    public function view(MessageBag $messages)
    {
        $cart = $this->dispatch(new GetCart());
        foreach ($cart->items as $item) {
            if ($item->entry_type == 'Visiosoft\AdvsModule\Adv\AdvModel') {
                $advModel = new AdvModel();
                $response_control = $advModel->stockControl($item->entry_id, $item->quantity);
                if ($response_control == "false") {
                    $cart->remove($item->id);//Remove item in cart
                    $messages->info("'" . $item->name . "' => " . trans('visiosoft.module.carts::message.error1in1'));
                }
            }
        }

        $cart = $this->dispatch(new GetCart());
        foreach ($cart->items as $index => $ad) {
            foreach ($cart->items as $index => $ad) {
                if ($ad->entry_type == 'Visiosoft\AdvsModule\Adv\AdvModel') {
                    $cart->items[$index]->detail_url = $advModel->getAdvDetailLinkByAdId($ad->entry_id);
                    $cart->items[$index]->cover_photo = $advModel->GetAdsDefaultCoverImageByAdId($ad->entry_id);
                } else {
                    $cart->items[$index]->cover_photo = $this->dispatch(new MakeImageInstance('theme::images/no-image-ads.jpg', 'img'))->url();
                    $cart->items[$index]->detail_url = "#";
                }
            }
        }
        $this->template->set('meta_title', 'Cart');
        return $this->view->make('visiosoft.module.carts::carts.view', compact('cart'));
    }

    public function bankOrder()
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $result = true;
        $cart = $this->dispatch(new GetCart());

        //Stock Control
        foreach ($cart->items as $item) {
            if ($item->entry_type == 'Visiosoft\AdvsModule\Adv\AdvModel') {
                $advModel = new AdvModel();
                $response_control = $advModel->stockControl($item->entry_id, $item->quantity);
                if ($response_control == "false") {
                    route('post.show', ['post' => 1]);
                    return route('visiosoft.module.carts::cart');
                    die;
                }
            }
        }

        $items = $cart->getItems();
        foreach ($items as $item) {
            if ($item->entry_type == 'Visiosoft\BalancesModule\Balance\BalanceModel') {
                $balanceController = app(\Visiosoft\BalancesModule\Http\Controller\BalancesFrontController::class);
                $balanceCartUpdate = $balanceController->cartUpdate($item->entry_id, $cart, 'bankorder');
                if (!$balanceCartUpdate) {
                    $result = false;
                }
            } else if ($item->entry_type == 'Visiosoft\PackagesModule\Package\PackageModel') {
                $packages = new PackageModel();
                $packages->PendingStatus($item->entry_id);
            } else if ($item->entry_type == 'Anomaly\Streams\Platform\Model\Dopings\DopingsDopingsEntryModel') {
                foreach ($items as $item) {
                    $doping = DopingsDopingsEntryModel::find($item->entry_id);
                    $doping->status = 'pending_approve';
                    $doping->save();
                }
            } else if ($item->entry_type == 'Visiosoft\AdvsModule\Adv\AdvModel') {
                foreach ($items as $item) {
                    $advModel = new AdvModel();
                    $advModel->updateStock($item->entry_id, $item->quantity);
                }
            }
        }
        if ($result) {
            $cart->delete();
        }
        $orderModel = new OrderModel();
        $order_id = $orderModel->getLastOrderByUser()->id;
        return Redirect::to(url('profile/order/' . $order_id));
    }

    public function fail($type = '')
    {
        $result = false;
        $cart = $this->dispatch(new GetCart());
        $message = '';
        if ($type == "balance") {
            $message = "message.balancefail";
        }
        return $this->view->make('visiosoft.module.carts::carts.result', compact('cart', 'result', 'message'));
    }

    public function success($type, Dispatcher $events, SettingRepositoryInterface $settings)
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $result = true;
        $cart = $this->dispatch(new GetCart());
        $items = $cart->getItems();

        $orderModel = new OrderModel();
        $orderModel->status('approved', $orderModel->getLastOrderByUser()->id);

        foreach ($items as $item) {
            if ($item->entry_type == 'Visiosoft\BalancesModule\Balance\BalanceModel') {
                $balanceController = app(\Visiosoft\BalancesModule\Http\Controller\BalancesFrontController::class);
                $balanceCartUpdate = $balanceController->cartUpdate($item->entry_id, $cart, $type);
                if (!$balanceCartUpdate) {
                    $result = false;
                }
            } else if ($item->entry_type == 'Visiosoft\PackagesModule\Package\PackageModel') {
                $packageEntryModel = new PackageEntryModel();
                $userentryModel = new UserentryModel();
                $package_model = new \Visiosoft\PackagesModule\User\UserModel();
                $package = $package_model->status($item->item_id, 'approved');
                $Packageentry = $packageEntryModel->getEntryPackage($package->package_id);
                $userentryModel->addEntryUserArray($Packageentry);
            } else if ($item->entry_type == 'Anomaly\Streams\Platform\Model\Dopings\DopingsDopingsEntryModel') {
                foreach ($items as $item) {
                    $approve = app(\Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController::class);
                    $approve->approve($item->entry_id);
                }
            } else if ($item->entry_type == 'Visiosoft\AdvsModule\Adv\AdvModel') {
                foreach ($items as $item) {
                    $advModel = new AdvModel();
                    $advModel->updateStock($item->entry_id, $item->quantity);
                }
            }
        }
        if ($result) {
            $cart->delete();
        }

        //get last order
        $order_id = $orderModel->getLastOrderByUser()->id;
        $events->dispatch(new Payment($order_id, $settings));

        return Redirect::to(url('profile/order/' . $order_id));
    }

    public function addOrders($items, $status, $bill, $delivery, $order_type = 'order')
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $isModule = new AdvModel();
        $isOrdersModule = $isModule->is_enabled('orders');

        if ($isOrdersModule) {
            $orderModel = new OrderModel();
            $orderDetailModel = new OrderdetailModel();

            $total = $orderModel->orders_total($items);
            $order_id = $orderModel->create_orders([
                'user' => Auth::id(), 'pay_type' => $order_type,
                'total' => $total, 'currency' => 'USD', 'status' => $status,
                'order_at' => date('Y-m-d H:i:s'), 'bill_address' => $bill,
                'delivery_address' => $delivery]);

            foreach ($items as $item) {
                if ($item->entry_type == 'Visiosoft\BalancesModule\Balance\BalanceModel') {
                    $orderDetailModel->create_datail(['item_id' => $item->entry_id, 'item_type' => 'balance', 'price' => $item->price,
                        'currency' => 'USD', 'piece' => 1, 'commission' => 1, 'total' => $item->price, 'order' => $order_id, 'status' => 'awaiting_payment']);
                } else if ($item->entry_type == 'Visiosoft\PackagesModule\Package\PackageModel') {
                    $orderDetailModel->create_datail(['item_id' => $item->entry_id, 'item_type' => 'package', 'price' => $item->price,
                        'currency' => 'USD', 'piece' => 1, 'commission' => 1, 'total' => $item->price, 'order' => $order_id, 'status' => 'awaiting_payment']);
                } else if ($item->entry_type == 'Anomaly\Streams\Platform\Model\Dopings\DopingsDopingsEntryModel') {
                    $orderDetailModel->create_datail(['item_id' => $item->entry_id, 'item_type' => 'doping', 'price' => $item->price,
                        'currency' => 'USD', 'piece' => 1, 'commission' => 1, 'total' => $item->price, 'order' => $order_id, 'status' => 'awaiting_payment']);
                } else if ($item->entry_type == 'Visiosoft\AdvsModule\Adv\AdvModel') {
                    $orderDetailModel->create_datail(['item_id' => $item->entry_id, 'item_type' => 'adv', 'price' => $item->price,
                        'currency' => 'USD', 'piece' => $item->quantity, 'commission' => 1, 'total' => $item->total, 'order' => $order_id, 'status' => 'awaiting_payment']);
                } else if ($item->entry_type == 'Anomaly\Streams\Platform\Model\Users\UsersUsersEntryModel') {
                    $orderDetailModel->create_datail(['item_id' => $item->entry_id, 'item_type' => 'Subscription', 'price' => $item->price,
                        'currency' => 'USD', 'piece' => 1, 'commission' => 1, 'total' => $item->price, 'order' => $order_id, 'status' => 'awaiting_payment']);

                }
            }
        }
    }

    public function review_cart(Request $request, Dispatcher $events)
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $address_Model = new AdressModel();
        $address = $address_Model->getUserAdress();
        $cart = $this->dispatch(new GetCart());
        $this->template->set('meta_title', 'Cart');
        $country = CountryModel::all();
        $pay_type = array();
        $pay_type = $events->dispatch(new CartsPay($pay_type));
        return $this->view->make('visiosoft.module.carts::carts.review', compact('cart', 'pay_type', 'country', 'address'));

    }

    public function send_request(Request $request, Dispatcher $events, SettingRepositoryInterface $settings)
    {
        if (!isset($request->license) and $request->license != "on") {
            return back();
            die;
        }
        $cart = $this->dispatch(new GetCart());
        $items = $cart->getItems();

        if (!isset($request->bill_address)) {
            $this->addOrders($items, 'pending', $request->delivery_address, $request->delivery_address, $request->pay_type);

        } else {
            $this->addOrders($items, 'pending', $request->bill_address, $request->delivery_address, $request->pay_type);
        }

        if ($request->pay_type == 'order') {
            $orderModel = new OrderModel();
            $order_id = $orderModel->getLastOrderByUser()->id;
            $events->dispatch(new Payment($order_id, $settings));
            return $this->bankOrder();
        } elseif ($request->pay_type == 'paypal') {
            return Redirect::to(url('payment/paypal'));
        } elseif ($request->pay_type == 'iyzico') {
            return Redirect::to(url('payment/iyzico'));
        } elseif ($request->pay_type == 'balance') {
            return Redirect::to(url('payment/balance'));
        } elseif ($request->pay_type == 'stripe') {
            return Redirect::to(url('payment/stripe'));
        }
    }

    public function getCart()
    {
        return $this->dispatch(new GetCart());
    }


    /**
     * Update all items in a cart.
     *
     * @param ItemRepositoryInterface $items
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(SaleitemRepositoryInterface $items, AdvRepositoryInterface $advRepository)
    {
        $current_item = array();
        $id = $this->request->get('id');
        $quantity = $this->request->get('quantity');
        $type = $this->request->get('type');
        $item = $items->find($id);
        $cart = $this->dispatch(new GetCart());

        if ($type == "remove") {
            $cart->remove($id);//Remove item in cart
            $current_item['cart'] = $this->getCart();
            $current_item['msg'] = "success";
            return $current_item;
        }
        //Get Quantity for Type
        $quantity = $items->getQuantity($quantity, $type, $item);

        if ($item) {
            if ($item->entry_type == "Visiosoft\AdvsModule\Adv\AdvModel") {

                //Get Adv in Cart
                $adv = $advRepository->findById($item->getAttribute('entry_id'));

                if ($adv->stock >= $quantity) {
                    $cart->remove($id);//Remove item in cart
                    $cart->add($adv, $quantity);//Add new item in cart
                    $current_item['cartItem'] = $this->dispatch(new GetCart())->items->last();//Get last item in Cart
                    $current_item['adv'] = $adv;
                    $current_item['cart'] = $this->getCart();
                    $current_item['msg'] = "success";
                } else {
                    $current_item['adv'] = $adv;
                    $current_item['msg'] = "error1";//No Limit
                    if ($adv->stock == 0) {
                        $current_item['msgContent'] = trans('visiosoft.module.carts::message.error1in1');//No Limit
                    } else {
                        $current_item['msgContent'] = trans('visiosoft.module.carts::message.error1in2');//No Limit
                    }
                }
            } else {
                $current_item['msg'] = "error2";//No Ads
                $current_item['msgContent'] = trans('visiosoft.module.carts::message.error2');//No Ads
            }

        } else {
            $current_item['msg'] = "error3";//No Cart İtem
            $current_item['msgContent'] = trans('visiosoft.module.carts::message.error3');//No Cart İtem
        }

        return $current_item;
    }


}
