<?php namespace Visiosoft\CartsModule\Cart\Command;

use Visiosoft\CartsModule\Cart\Contract\CartInterface;

/**
 * Class TotalCart
 *
 * @link   http://openclassify.com/
 * @author OpenClassify, Inc. <support@openclassify.com>
 * @author Visiosoft Inc <support@openclassify.com>
 */
class TotalCart
{

    /**
     * The cart instance.
     *
     * @var CartInterface
     */
    protected $cart;

    /**
     * Create a new TotalCart instance.
     *
     * @param CartInterface $cart
     */
    public function __construct(CartInterface $cart)
    {
        $this->cart = $cart;
    }

    /**
     * Handle the command.
     */
    public function handle()
    {
        $items = $this->cart->getItems();

        $this->cart->setAttribute('quantity', $items->quantity());
        $this->cart->setAttribute('subtotal', $items->subtotal());
        $this->cart->setAttribute('tax', $items->tax() + $this->cart->calculate('tax'));
        $this->cart->setAttribute('shipping', setting_value('visiosoft.module.orders::shipping'));
        $this->cart->setAttribute('discounts', $items->discounts() + $this->cart->calculate('discount'));
        $this->cart->setAttribute('commission', $items->commission() + $this->cart->calculate('commission'));

        $this->cart->setAttribute(
            'total',
            $this->cart->getSubtotal()
            - $this->cart->getDiscounts()
            + $this->cart->getShipping()
            + $this->cart->getTax()
            + $this->cart->getCommission()
        );
    }
}
