const priceInput = document.querySelector('#price');
const commissionTable = $('.commission-table')
const gETCheckbox = $('input[name=is_get_adv]')

priceInput.addEventListener('priceChangedEvent', function (e) {
    if (e.detail.newPrice > 0) {
        if (gETCheckbox[0].checked) {
            changeCommissionTable(e.detail.newPrice)
            commissionTable.removeClass('d-none')
        }
    } else {
        commissionTable.addClass('d-none')
    }
});

gETCheckbox.on('change', function () {
    if (gETCheckbox[0].checked) {
        const price = $('#price').val()
        if (price > 0) {
            changeCommissionTable(price)
            commissionTable.removeClass('d-none')
        }
    } else {
        commissionTable.addClass('d-none')
    }
})

const changeCommissionTable = (price) => {
    const serviceAmount = price * commission / 100
    $('#service-commission').text(serviceAmount.toFixed(2))
    $('#customer-commission').text((price - serviceAmount).toFixed(2))
}