<?php namespace Visiosoft\CartsModule;

// use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\CartsModule\Saleitem\Contract\SaleitemRepositoryInterface;
use Visiosoft\CartsModule\Saleitem\SaleitemRepository;
use Anomaly\Streams\Platform\Model\Carts\CartsSaleitemsEntryModel;
use Visiosoft\CartsModule\Saleitem\SaleitemModel;
use Visiosoft\CartsModule\Ad\Contract\AdRepositoryInterface;
use Visiosoft\CartsModule\Ad\AdRepository;
use Anomaly\Streams\Platform\Model\Carts\CartsAdsEntryModel;
use Visiosoft\CartsModule\Ad\AdModel;
use Visiosoft\CartsModule\Saleitem\SaleitemProcessor;
use Visiosoft\CartsModule\Saleitem\Listener\ProcessSaleitems;

use Visiosoft\CartsModule\Cart\CartModel;
use Visiosoft\CartsModule\Cart\CartProcessor;
use Visiosoft\CartsModule\Cart\CartRepository;
use Visiosoft\CartsModule\Cart\Contract\CartRepositoryInterface;
use Visiosoft\CartsModule\Cart\Listener\AddUserToCart;
use Visiosoft\CartsModule\Cart\Listener\ProcessCart;
use Visiosoft\CartsModule\Modifier\Contract\ModifierRepositoryInterface;
use Visiosoft\CartsModule\Modifier\ModifierModel;
use Visiosoft\CartsModule\Modifier\ModifierRepository;
use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\Carts\CartsCartsEntryModel;
use Anomaly\Streams\Platform\Model\Carts\CartsItemsEntryModel;
use Anomaly\Streams\Platform\Model\Carts\CartsModifiersEntryModel;
use Anomaly\UsersModule\User\Event\UserWasLoggedIn;
use Illuminate\Contracts\Config\Repository;

class CartsModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [
        CartsModulePlugin::class,
    ];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/carts/saleitems'           => 'Visiosoft\CartsModule\Http\Controller\Admin\SaleitemsController@index',
        'admin/carts/saleitems/create'    => 'Visiosoft\CartsModule\Http\Controller\Admin\SaleitemsController@create',
        'admin/carts/saleitems/edit/{id}' => 'Visiosoft\CartsModule\Http\Controller\Admin\SaleitemsController@edit',
        'admin/carts/ads'           => 'Visiosoft\CartsModule\Http\Controller\Admin\AdsController@index',
        'admin/carts/ads/create'    => 'Visiosoft\CartsModule\Http\Controller\Admin\AdsController@create',
        'admin/carts/ads/edit/{id}' => 'Visiosoft\CartsModule\Http\Controller\Admin\AdsController@edit',
        'admin/carts/items'           => 'Visiosoft\CartsModule\Http\Controller\Admin\temsController@index',
        'admin/carts/items/create'    => 'Visiosoft\CartsModule\Http\Controller\Admin\ItemsController@create',
        'admin/carts/items/edit/{id}' => 'Visiosoft\CartsModule\Http\Controller\Admin\ItemsController@edit',
        'cart'                    => [
            'as'   => 'visiosoft.module.carts::cart',
            'uses' => 'Visiosoft\CartsModule\Http\Controller\CartsController@view',
        ],
        'carts/{instance}'        => [
            'as'   => 'visiosoft.module.carts::carts.view',
            'uses' => 'Visiosoft\CartsModule\Http\Controller\CartsController@view',
        ],
        'cart/review'        => [
            'as'   => 'visiosoft.module.carts::carts.review',
            'uses' => 'Visiosoft\CartsModule\Http\Controller\CartsController@review_cart',
        ],
        'carts/{instance}/update' => [
            'as'   => 'visiosoft.module.carts::carts.update',
            'uses' => 'Visiosoft\CartsModule\Http\Controller\CartsController@send_request',
        ],
        'carts/items/remove/{id}' => [
            'as'   => 'visiosoft.module.carts::items.remove',
            'uses' => 'Visiosoft\CartsModule\Http\Controller\SaleitemsController@remove',
        ],
        'cart/bankorder' => 'Visiosoft\CartsModule\Http\Controller\CartsController@bankOrder',
        'payment/fail' => 'Visiosoft\CartsModule\Http\Controller\CartsController@fail',
        'payment/success/{type}' => 'Visiosoft\CartsModule\Http\Controller\CartsController@success',
        'cart/quantity' => 'Visiosoft\CartsModule\Http\Controller\CartsController@update',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\CartsModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\CartsModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        UserWasLoggedIn::class => [
            AddUserToCart::class,
            ProcessSaleitems::class,
            ProcessCart::class,
        ],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\CartsModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        CartsSaleitemsEntryModel::class => SaleitemModel::class,
        CartsModifiersEntryModel::class => ModifierModel::class,
        CartsCartsEntryModel::class => CartModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        SaleitemRepositoryInterface::class => SaleitemRepository::class,
        CartProcessor::class               => CartProcessor::class,
        SaleitemProcessor::class               => SaleitemProcessor::class,
        CartRepositoryInterface::class     => CartRepository::class,
        ModifierRepositoryInterface::class => ModifierRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register(CartProcessor $carts, SaleitemProcessor $items, Repository $config)
    {
        $items->setProcessors($config->get($this->addon->getNamespace('processors.items'), []));
        $carts->setProcessors($config->get($this->addon->getNamespace('processors.carts'), []));
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
