<?php namespace Visiosoft\CartsModule\Saleitem\Command;

use Visiosoft\CartsModule\Cart\Contract\CartInterface;
use Visiosoft\CartsModule\Saleitem\Contract\SaleitemInterface;
use Visiosoft\CartsModule\Saleitem\Contract\SaleitemRepositoryInterface;
use Anomaly\Streams\Platform\Model\EloquentModel;

/**
 * Class UpdateItem
 *
 * @link   http://openclassify.com/
 * @author OpenClassify, Inc. <support@openclassify.com>
 * @author Visiosoft Inc <support@openclassify.com>
 */
class UpdateSaleitem
{

    /**
     * The cart instance.
     *
     * @var CartInterface
     */
    protected $cart;

    /**
     * The item ID.
     *
     * @var int
     */
    protected $id;

    /**
     * The item parameters.
     *
     * @var array
     */
    protected $parameters;

    /**
     * Create a new UpdateItem instance.
     *
     * @param CartInterface $cart
     * @param $item
     * @param int $quantity
     */
    public function __construct(CartInterface $cart, $id, array $parameters)
    {
        $this->id         = $id;
        $this->cart       = $cart;
        $this->parameters = $parameters;
    }

    /**
     * Handle the command.
     *
     * @return ItemInterface
     * @throws \Exception
     */
    public function handle(SaleitemRepositoryInterface $items)
    {
        /* @var ItemInterface|EloquentModel $item */
        $item = $this->cart->getItems()->find($this->id);

        if ($quantity = array_pull($this->parameters, 'quantity')) {
            $item->setAttribute('quantity', $quantity);
        }

        $item->fill($this->parameters);

        $items->save($item);

        return $item;
    }
}
