//Address Area
getCountriesBilling()
    .then(function () {
        return getCitiesBilling($('select[name="billing_country"]').val());
    });

function getCountriesBilling() {
    return crudAjax('', '/ajax/getCountry', 'GET', function (callback) {
        $('select[name="billing_country"]').html("<option hidden>...</option>");
        $.each(callback, function (index, value) {
            var selected = (value.abv.toLowerCase() == app_locale) ? 'selected' : '';
            $('select[name="billing_country"]').append("<option " + selected + " value='" + value.id + "'>" + value.name + "</option>");
        });
    }, true)
}

function getCitiesBilling(country) {
    const selectsInput = $('select[name=billing_city], select[name=billing_district]')
    selectsInput.prop('disabled', true)

    $('select[name="billing_district"]').html("<option hidden>...</option>");

    return crudAjax(`id=${country}`, '/ajax/getCities', 'POST', () => {
    }, true)
        .then(function (cities) {
            $('select[name="billing_city"]').html("<option hidden>...</option>");
            $.each(cities, function (index, value) {
                $('select[name="billing_city"]').append("<option value='" + value.id + "'>" + value.name + "</option>");
            });
            selectsInput.prop('disabled', false)
        })
}

function getDistrictsBilling(city) {
    const selectDistrictInput = $('select[name=billing_district]');
    selectDistrictInput.prop('disabled', true)

    return crudAjax(`id=${city}`, '/ajax/getDistricts', 'POST', () => {
    }, true)
        .then(function (districts) {
            $('select[name="billing_district"]').html("<option value=''>...</option>");
            $.each(districts, function (index, value) {
                $('select[name="billing_district"]').append("<option value='" + value.id + "'>" + value.name + "</option>");
            });
            selectDistrictInput.prop('disabled', false)
        })
}

$('select[name="billing_country"]').on('change', function () {
    getCitiesBilling($(this).val());
});

$('select[name="billing_city"]').on('change', function () {
    getDistrictsBilling($(this).val());
});