<?php namespace Visiosoft\CartsModule\Saleitem\Listener;

use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CartsModule\Cart\Contract\CartInterface;
use Visiosoft\CartsModule\Saleitem\Contract\SaleitemInterface;
use Visiosoft\CartsModule\Saleitem\SaleitemProcessor;
use Illuminate\Foundation\Bus\DispatchesJobs;

/**
 * Class ProcessItems
 *
 * @link   http://openclassify.com/
 * @author OpenClassify, Inc. <support@openclassify.com>
 * @author Visiosoft Inc <support@openclassify.com>
 */
class ProcessSaleitems
{

    use DispatchesJobs;

    /**
     * The cart processor.
     *
     * @var ItemProcessor
     */
    protected $processor;

    /**
     * Create a new ProcessItems instance.
     *
     * @param ItemProcessor $processor
     */
    public function __construct(SaleitemProcessor $processor)
    {
        $this->processor = $processor;
    }

    /**
     * Handle the event.
     */
    public function handle()
    {
        /* @var CartInterface $cart */
        $cart = $this->dispatch(new GetCart());

        /* @var ItemInterface $item */
        foreach ($cart->getItems() as $item) {
            $this->processor->process($item);
        }
    }
}
