<?php namespace Visiosoft\CartsModule\Http\Controller;

use Visiosoft\CartsModule\Saleitem\Contract\SaleitemInterface;
use Visiosoft\CartsModule\Saleitem\Contract\SaleitemRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\Streams\Platform\Model\EloquentModel;
use Visiosoft\PackagesModule\User\UserModel;

/**
 * Class ItemsController
 *
 * @link          http://openclassify.com/
 * @author        OpenClassify, Inc. <support@openclassify.com>
 * @author        Visiosoft Inc <support@openclassify.com>
 * @package       Visiosoft\CartsModule\Http\Controller
 */
class SaleitemsController extends PublicController
{

    /**
     * Remove an item from the cart.
     *
     * @param ItemRepositoryInterface $items
     * @param                         $instance
     * @param                         $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function remove(SaleitemRepositoryInterface $items, $id)
    {
        /* @var ItemInterface|EloquentModel $item */
        if ($item = $items->find($id)) {
            if($item->entry_type == 'Visiosoft\PackagesModule\User\UserModel'){
                $packages = UserModel::find($item->entry_id);
                $packages->delete();
            }
            $items->delete($item);
        }

        return $this->redirect->back();
    }
}
